<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		RSSEdit.class.php
 * @brief		RSS設定の編集クラス
 * @date		2006.12.18
 */

require_once(CLASS_DIR."/form/RSSInputForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/file/MakeHtaccess.class.php");

class RSSEdit extends RSSInputForm
{
	function makeForm()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; RSS設定編集");
		
		$this->dao = new GroupManager();
		$group_array = $this->dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$this->current_group = $this->dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			case 3 :{$this->complete();break;}	// 完了
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$this->assign("state",2);
		$this->assign("meta_description",$this->current_group["group_meta_description"]);
		$this->assign("rss_output_num",$this->current_group["group_rss_output_num"]);
		$this->assign("rss1_output",$this->current_group["group_rss1_output"]);
		$this->assign("rss2_output",$this->current_group["group_rss2_output"]);
		$this->assign("atom_output",$this->current_group["group_atom_output"]);
		$this->assign("rss1_file_name",$this->current_group["group_rss1_file_name"]);
		$this->assign("rss2_file_name",$this->current_group["group_rss2_file_name"]);
		$this->assign("atom_file_name",$this->current_group["group_atom_file_name"]);
		$this->assign("rss_copyright",$this->current_group["group_rss_copyright"]);
		$this->assign("rss_creator",$this->current_group["group_rss_creator"]);
		$this->template = "RSSEditInput.tpl";
	}
	
	// 確認
	function confirm()
	{
		$this->setMetaDescription($_POST["meta_description"]);
		$this->setRSSOutputNum($_POST["rss_output_num"]);
		$this->setRSS1Output($_POST["rss1_output"]);
		$this->setRSS2Output($_POST["rss2_output"]);
		$this->setATOMOutput($_POST["atom_output"]);
		$this->setRSS1FileName($_POST["rss1_file_name"]);
		$this->setRSS2FileName($_POST["rss2_file_name"]);
		$this->setATOMFileName($_POST["atom_file_name"]);
		$this->setRSSCopyright($_POST["rss_copyright"]);
		$this->setRSSCreator($_POST["rss_creator"]);
		$form_error_array = $this->check();
		
		if((count($form_error_array) > 0) || ($_POST["back"]))
		{
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->template = "RSSEditInput.tpl";
		}
		else
		{
			$this->assign("state",3);
			$this->assign("message_array","下記の内容で登録します。よろしければ「登録」ボタンを押してください。<br />修正をする場合は「編集」ボタンよりお戻りください。");
			$this->template = "RSSEditConfirm.tpl";
		}
		
		$this->assign("meta_description",$_POST["meta_description"]);
		$this->assign("rss_output_num",$_POST["rss_output_num"]);
		$this->assign("rss1_output",$_POST["rss1_output"]);
		$this->assign("rss2_output",$_POST["rss2_output"]);
		$this->assign("atom_output",$_POST["atom_output"]);
		$this->assign("rss1_file_name",$_POST["rss1_file_name"]);
		$this->assign("rss2_file_name",$_POST["rss2_file_name"]);
		$this->assign("atom_file_name",$_POST["atom_file_name"]);
		$this->assign("rss_copyright",$_POST["rss_copyright"]);
		$this->assign("rss_creator",$_POST["rss_creator"]);
	}
	
	// 完了
	function complete()
	{
		$record = array();
		$record["group_meta_description"] = $_POST["meta_description"];
		$record["group_rss_output_num"] = $_POST["rss_output_num"];
		$record["group_rss1_output"] = $_POST["rss1_output"];
		$record["group_rss2_output"] = $_POST["rss2_output"];
		$record["group_atom_output"] = $_POST["atom_output"];
		$record["group_rss1_file_name"] = $_POST["rss1_file_name"];
		$record["group_rss2_file_name"] = $_POST["rss2_file_name"];
		$record["group_atom_file_name"] = $_POST["atom_file_name"];
		$record["group_rss_copyright"] = $_POST["rss_copyright"];
		$record["group_rss_creator"] = $_POST["rss_creator"];
		$code = $_GET["group_code"];
		
		$this->dao->StartTrans();
		$this->dao->Lock();
		$this->dao->updGroup($record,$code);
		if(!$this->dao->CompleteTrans())
			$this->error("RSS設定の修正に失敗しました。");
		
		$htaccess = new MakeHtaccess();
		if(!$htaccess->execute())
			$this->error("RSS設定の修正に失敗しました。");
		
		$_POST["state"] = 1;
		$this->assign("message_array","変更内容を保存しました。");
		
		$this->makeForm();
	}
	
	function render()
	{
		$this->makeForm();
		$this->renderForm();
	}
}
