<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		TemplateModuleManager.class.php
 * @brief		template_moduleテーブルの処理を行うクラス
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

class TemplateModuleManager extends BitcubeDB
{
	function TemplateModuleManager()
	{
		$this->BitcubeDB();
	}
	
	// モジュールテンプレート情報取得
	function getTemplateModuleInfo($code)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->template_module.module_code ";
		$sql .= " ,$this->template_module.group_code ";
		$sql .= " ,$this->template_module.module_name ";
		$sql .= " ,$this->template_module.module_file_name ";
		$sql .= " ,$this->template_module.module_body ";
		$sql .= " from ";
		$sql .= " $this->template_module ";
		$sql .= " where $this->template_module.is_delete = 0 and $this->template_module.module_code = $code ";
		
		return $this->GetRow($sql);
	}
	
	// モジュールテンプレート情報一覧取得
	function getTemplateModuleList($orderby="",$condition="",$offset=-1,$limit=-1)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->template_module.module_code ";
		$sql .= " ,$this->template_module.group_code ";
		$sql .= " ,$this->template_module.module_name ";
		$sql .= " ,$this->template_module.module_file_name ";
		$sql .= " from ";
		$sql .= " $this->template_module ";
		
		// 条件文
		$condition = ($condition) ?
			" where $this->template_module.is_delete = 0 and $condition ":
			" where $this->template_module.is_delete = 0 ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		
		$sql .= $condition.$orderby;
		
		$rs = $this->SelectLimit($sql,$limit,$offset);
		
		return $rs->GetArray();
	}
	
	// モジュールテンプレート情報追加
	function insTemplateModule($record)
	{
		$record["module_code"] = $this->getNextModuleCode();
		$record["module_file_name"] = "module".$this->getNextModuleCode().".dat";
		$record["is_delete"] = 0;
		
		return $this->ExecuteInsert($this->template_module,$record);
	}
	
	// 新規追加されるコードを取得
	function getNextModuleCode()
	{
		return $this->getLastModuleCode() + 1;
	}
	
	// 最新コードを取得
	function getLastModuleCode()
	{
		return $this->GetMax($this->template_module,"module_code");
	}
	
	// モジュールテンプレート情報編集
	function updTemplateModule($record,$code)
	{
		return $this->ExecuteUpdate($this->template_module,$record,"module_code = ".$code);
	}
	
	// モジュールテンプレート情報削除
	function delTemplateModule($code)
	{
		$record["is_delete"] = 1;
		return $this->ExecuteUpdate($this->template_module,$record,"module_code = ".$code);
	}
	
	// テーブルをロック
	function Lock()
	{
		$this->doLock($this->template_module);
	}
}
