<?php
/*
 * @file		block.BCEntrys.php
 * @brief		
 * @author		Hiroshi Tanimoto
 * @date		2006.07.14
 ***************************************************************************
 *	リスト・コンテナタグ：
 *　　bitCubeのエントリー情報用のコンテナ・タグです。
 *　　アトリビュートを指定することで、特定のグループや、カテゴリのエントリーを抜き出すことや、指定した数のエントリーを一覧することができます。
 *  属性
 *    entry_publish = "0|1"
 *     ・0=未公開のエントリー 1=公開中のエントリ
 *    entry_code = N
 *     ・指定されたエントリー番号の情報を取得します。
 *    entry_name = ""
 *     ・指定されたエントリー名の情報を取得します。
 *    group_code = N
 *     ・指定されたグループ番号の情報を取得します。
 *    group_name = ""
 *     ・指定されたグループ名の情報を取得します。
 *    category_code = N
 *     ・指定されたカテゴリ番号の情報を取得します。
 *       カテゴリに属していないエントリーを取得するには、「category_code = 'noncategorize'」と指定します。
 *    category_name = ""
 *     ・指定されたカテゴリ名の情報を取得します。
 *  　lastn = N
 *     ・指定された件数を表示します。
 *    sort_by = "entry_code|category_code|group_code|entry_order|page_view|adddate|upddate"
 *     ・並び替える対象を指定します。
 *         entry_code（エントリーコード順）、
 *         category_code(カテゴリコード順)、
 *         group_code(グループコード順)、
 *         entry_order(エントリー並び順)、
 *         page_view(ページ閲覧数順)、
 * 　　　adddate（エントリー追加日）、
 * 　　　upddate（エントリー更新日）が指定できます。
 *    sort_order="ascend | descend"
 *     ・並べる順序を指定します。ascendを指定すると昇順、descendは降順になります。
 *　使用方法
 *	　<[BCEntrys]><[/BCEntrys]>
 ***************************************************************************
 */

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

function smarty_block_BCEntrys($params, $content, &$smarty, &$repeat)
{
	static $instance_cnt 	= 0;				//インスタンス生成数
	static $aryloopcnt		= array();	//処理待機用配列
	static $aryrs			 		= array();	//検索結果待機用配列
	static $aryattribute	= array();	//属性待機用配列
	static $aryNestValue = array(); //タグネスト時の値を待機

	//*********************
	//「開始タグ」
	//*********************
	if(is_null($content))	//コンテンツ=nullでループ回数=0の場合は初期
	{
		//初期処理
		init_BCEntrys($params,&$rs);		
		
		//属性設定
		attribute_BCEntrys($params,&$rs,&$attribute);

		//初期化
		$loopcnt = 0;
		
		//インスタンス生成数制御
		$instance_cnt++;

		//現在入っているBCMSMSemianrsデータを待機
		$aryNestValue[$instance_cnt] = $smarty->_tpl_vars["BCEntrys"];
		
		//結果を配列へ待機
		$aryloopcnt[$instance_cnt] = $loopcnt;
		$aryrs[$instance_cnt] = $rs;
		$aryattribute[$instance_cnt] = $attribute;
	}

	//現在処理している情報を取得
	$loopcnt 		= $aryloopcnt[$instance_cnt];
	$rs					= $aryrs[$instance_cnt];
	$attribute	= $aryattribute[$instance_cnt];
	
	//*********************
	//「共通処理」
	//*********************
	//チェック処理
	$rtn = check_BCEntrys(&$loopcnt,&$rs);
	if(!$rtn)
	{
		//終了処理		
		terminate_BCEntrys(&$smarty,$instance_cnt,$aryNestValue[$instance_cnt]);
		$repeat = false;
		return $content;			
	}	

	//メイン処理
	main_BCEntrys(&$smarty,&$loopcnt,&$rs);

	//処理回数を待機
	$aryloopcnt[$instance_cnt] = $loopcnt;
	
	//*********************
	//「終了タグ」
	//*********************
	if(!is_null($content))
	{	

		if($loopcnt>$attribute['lastn'])
		{
			//終了処理
			terminate_BCEntrys(&$smarty,$instance_cnt,$aryNestValue[$instance_cnt]);
			$repeat = false;
			return $content;
		}
		else
		{
			//処理継続
			$repeat = true;
			return $content;
		}			
	}
}

/*
 * 
 */
function init_BCEntrys($params,&$rs)
{
	$dao = new BitcubeDB();
	
	//------------------------------
	//開始タグ時
	//------------------------------
	$sql  = " select "; 
	$sql .= " $dao->entry.entry_code ";
	$sql .= " ,$dao->entry.group_code ";
	$sql .= " ,$dao->entry.category_code ";
	$sql .= " ,$dao->entry.entry_regist_date ";
	$sql .= " ,$dao->entry.entry_modification_date ";
	$sql .= " ,$dao->entry.entry_date ";
	$sql .= " ,$dao->entry.entry_publish ";
	$sql .= " ,$dao->entry.entry_title ";
	$sql .= " ,$dao->entry.entry_body ";
	$sql .= " ,$dao->entry.entry_order ";
	$sql .= " ,$dao->group.group_regist_date ";
	$sql .= " ,$dao->group.group_modification_date ";
	$sql .= " ,$dao->group.group_name ";
	$sql .= " ,$dao->group.group_dir_name ";
	$sql .= " ,$dao->group.group_upload_dir_name ";
	$sql .= " ,$dao->group.group_summary_strings_num ";
	$sql .= " ,$dao->category.category_name ";
	$sql .= " ,$dao->category.category_order ";
	$sql .= " from ";
	$sql .= " $dao->entry left join $dao->group on $dao->group.is_delete = 0 and $dao->entry.group_code = $dao->group.group_code "; 
	$sql .= " left join $dao->category on $dao->category.is_delete = 0 and $dao->entry.category_code = $dao->category.category_code and $dao->entry.group_code = $dao->category.group_code ";
	
	//---------------
	//検索条件設定
	//---------------
	$temp_con = null;
	if(isset($params['entry_publish']))
	{
		$temp_con .= "$dao->entry.entry_publish=".$params['entry_publish'];
	}
	$condition = $temp_con;
	
	$temp_con = null;
	if(isset($params['entry_code']) && $params['entry_code'] != "")
	{
		//条件文生成
		$temp_con = getCondition_BCEntrys($params['entry_code'],"$dao->entry.entry_code","int");
	}
	elseif(isset($params['entry_name']) && $params['entry_name'] != "")
	{
		//条件文生成
		$temp_con = getCondition_BCEntrys($params['entry_name'],"$dao->entry.entry_title","char");
	}
	if(isset($temp_con))
	{
		if(isset($condition))
		{
			$condition .= " and ";
		}
		$condition .= "(".$temp_con.")";
	}

	$temp_con = null;
	if(isset($params['group_code']) && $params['group_code'] != "")
	{
		//条件文生成
		$temp_con = getCondition_BCEntrys($params['group_code'],"$dao->group.group_code","int");
	}
	elseif(isset($params['group_name']) && $params['group_name'] != "")
	{
		//条件文生成
		$temp_con = getCondition_BCEntrys($params['group_name'],"$dao->group.group_name","char");
	}
	if(isset($temp_con))
	{
		if(isset($condition))
		{
			$condition .= " and ";
		}
		$condition .= "(".$temp_con.")";
	}
	
	$temp_con = null;
	if(isset($params['category_code']) && $params['category_code'] != "")
	{
		//条件文生成
		if(($params['category_code'] == 'NONCATEGORIZE') || ($params['category_code'] == 'noncategorize'))
		{
			$temp_con = getCondition_BCEntrys(0,"$dao->entry.category_code","int");
		}
		else
		{
			$temp_con = getCondition_BCEntrys($params['category_code'],"$dao->entry.category_code","int");
		}
	}
	elseif(isset($params['category_name']) && $params['category_name'] != "")
	{
		//条件文生成
		$temp_con = getCondition_BCEntrys($params['category_name'],"$dao->category.category_name","char");
	}
	
	if(isset($temp_con))
	{
		if(isset($condition))
		{
			$condition .= " and ";
		}
		$condition .= "(".$temp_con.")";
	}
	
	$order = "";
	switch($params['sort_order'])
	{
		case "ascend":	{$order=" asc ";break;	}
		case "descend":	{$order=" desc ";break;	}
		default:{$order=" ";break;}
	}
	
	//並び替え設定
	//存在すればここで処理
	switch($params['sort_by'])
	{
		case "entry_code":		{$orderby="$dao->entry.entry_code".$order;break;}
		case "category_code":	{$orderby="$dao->entry.category_code".$order;break;}
		case "group_code":		{$orderby="$dao->entry.group_code".$order;break;}
		case "entry_order":		{$orderby="$dao->entry.entry_order".$order;break;}
		case "page_view":		{$orderby="$dao->entry.entry_page_view".$order;break;}
		case "adddate":			{$orderby="$dao->entry.entry_regist_date".$order;break;}
		case "upddate":			{$orderby="$dao->entry.entry_modification_date".$order;break;}
		default:{$orderby="$dao->entry.entry_order"." desc ";break;}
	}
	
	if($condition!="")
	{
		$sql .= " where $dao->entry.is_delete = 0 and ".$condition;
	}
	else
	{
		$sql .= " where $dao->entry.is_delete = 0 ";
	}
	
	if($orderby!="")
	{
		$sql .= " order by ".$orderby;
	}
	
	$rs = array();
	$rs = $dao->GetAll($sql);
}

/*
 * 
 */
function attribute_BCEntrys($params,&$rs,&$attribute)
{
	
	//表示件数設定
	//※未設定時には全て
	if(isset($params['lastn']) && $params['lastn'] != "" )
	{
		$lastn = $params['lastn'];
	}
	else
	{
		$lastn = count($rs);
	}
	if($lastn>count($rs))
	{
		$lastn = count($rs);
	}
	
	//属性セット
	$attribute['lastn'] = $lastn;
}
/*
 * 
 * 
 */
function check_BCEntrys(&$loopcnt,&$rs)
{
	//対象データ存在チェック
	if(($loopcnt+1)>count($rs))
	{
		return false;
	}

	return true;
}
 
/*
 * 
 */
function main_BCEntrys(&$smarty,&$loopcnt,&$rs)
{
	//テンプレート変数へセット
	$items = array();
	
	$description = $rs[$loopcnt]["entry_body"];
	$description = strip_tags($description);
	$description = str_replace("\n","",$description);
	
	$items['EntryCode'] = $rs[$loopcnt]['entry_code'];
	$items['GroupCode'] = $rs[$loopcnt]['group_code'];
	$items['CategoryCode'] = $rs[$loopcnt]['category_code'];
	$items['EntryRegistDate'] = $rs[$loopcnt]['entry_regist_date'];
	$items['EntryModificationDate'] = $rs[$loopcnt]['entry_modification_date'];
	$items['EntryDate'] = $rs[$loopcnt]['entry_date'];
	$items['EntryPublish'] = $rs[$loopcnt]['entry_publish'];
	$items['EntryTitle'] = $rs[$loopcnt]['entry_title'];
	$items['EntryBody'] = $rs[$loopcnt]['entry_body'];
	$items["EntryDescription"] = mb_substr($description,0,$rs[$loopcnt]["group_summary_strings_num"]);
	$items['EntryOrder'] = $rs[$loopcnt]['entry_order']; 
	$items['GroupRegistDate'] = $rs[$loopcnt]['group_regist_date'];
	$items['GroupModificationDate'] = $rs[$loopcnt]['group_modification_date'];
	$items['GroupName'] = $rs[$loopcnt]['group_name'];	
	$items['GroupHttpServerDirPath'] = CURRENT_HTTP_SERVER.$rs[$loopcnt]['group_dir_name']."/";
	$items['GroupUploadDirPath'] = CURRENT_HTTP_SERVER.$rs[$loopcnt]['group_dir_name']."/".$rs[$loopcnt]['group_upload_dir_name']."/";
	$items['CategoryName'] = $rs[$loopcnt]['category_name'];
	$items['CategoryOrder'] = $rs[$loopcnt]['category_order'];
	
	// 自身の変数
	$iteration = $loopcnt + 1;
	$items["iteration"] = $iteration;
	$items["first"] = ($iteration == 1) ? true : false;
	$items["last"] = ($iteration == count($rs)) ? true : false;
	
	//テンプレート変数へセット
	$smarty->assign("BCEntrys", $items);
	
	$loopcnt++;
}

/*
 * 
 */
function terminate_BCEntrys(&$smarty,&$instance_cnt,$aryNestValue)
{
	$smarty->clear_assign("BCEntrys");

	//インスタンス生成数をカウントダウン
	$instance_cnt--;

	if($instance_cnt > 0)
	{
		if(isset($aryNestValue))
		{
			$smarty->assign("BCEntrys",$aryNestValue);
		}
	}
}

function getCondition_BCEntrys($value,$fieldname,$type)
{
	$temp_condition = "";
	$items = split(",",$value);

	foreach($items as $item)
	{
		if(isset($temp_con))
		{
			$temp_condition = $temp_condition." or ";
		}
		
		switch($type)
		{
			case "int":
			{
				$temp_condition = $temp_condition.$fieldname."=".$item;
				break;
			}
			default:
			{
				$temp_condition = $temp_condition.$fieldname."='".$item."'";
				break;
			}
		}	
	}
	
	return $temp_condition;
}
?>