/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.ig.expander.Value;

/**
 * @author Yasuo Nakanishi
 */
public class DataStructDefinition {
    private String _name = ""; 
    private List _constructValueList = new ArrayList();
    private List _fieldList = new ArrayList();
    private List _lists = new ArrayList();
    private boolean _enebledJavaDoc = false;

    public DataStructDefinition(String name) {
        _name = name;
    }
    
    public String getName() {
        return _name;
    }
    
    public void addConstructValues(Value[] values) {
        _constructValueList.add(values);
    }
    
    public int getConstructorCount() {
        return _constructValueList.size();
    }
    
    public Value[] getConstructValues(int index) {
        return (Value[]) _constructValueList.get(index);
    }
    
    public void addField(DataStructField field) {
        _fieldList.add(field);
    }
    
    public int getFieldCount() {
        return _fieldList.size();
    }

    public DataStructField getField(int index) {
        return (DataStructField) _fieldList.get(index);
    }
    
    public void addList(ListOption list) {
        _lists.add(list);
    }

    public int getListCount() {
        return _lists.size();
    }

    public ListOption getList(int index) {
        return (ListOption) _lists.get(index);
    }

    public Iterator getFieldIterator() {
        return _fieldList.iterator();
    }

    public boolean isEnebledJavaDoc() {
        return _enebledJavaDoc;
    }
    

    public void setEnebledJavaDoc(boolean enebleJavaDoc) {
        _enebledJavaDoc = enebleJavaDoc;
    }
    
}
