/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Cast;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class GetListItemMethod extends MethodExpander {
    private String _fieldName = null;
    private Type _itemType = null;

    public static String createName(String baseName) {
        return MethodExpander.createName("get", baseName) ;
    }

    public GetListItemMethod(String baseName, String fieldName, Type itemType) {
        super(createName(baseName));
        _fieldName = fieldName;
        _itemType = itemType;
        
    }

    public void setupSignature() {
        addArgument(getIndexArgument());

        setReturnType(_itemType);
    }

    public void implement() {
        Implementor i = new Implementor(getData());
        Cast cast = new Cast(_itemType);
        Receiver r = new Receiver(_fieldName);
        Call c = r.call("get");
        c.addArgument(getIndexArgument());
        cast.setStatement(r);
        i.addReturn(cast);
    }
    
    private Value getIndexArgument() {
        return new Value(new Type(int.class), "index");
    }
}
