/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct.test;

import blanco.core.datastruct.DataStructDefinition;
import blanco.core.test.TestCaseClass;
import blanco.ig.expander.Type;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class DataStructTestClass extends TestCaseClass {
    private DataStructDefinition _definition = null;
    private String _targetName = "";
    private FieldTestData _testData = null;

    public DataStructTestClass(Type target, DataStructDefinition definition) {
        super(target);
        _definition = definition;
    }
    
    public void expandClassStruct() {
        _testData = createTestData();
        _testData.createTestData(_definition);
        
        addMethod(createToStringMethod());
        addMethod(createTestAccesorMethod());
    }

    protected MethodExpander createToStringMethod() {
        Type targetType = new Type(getNameSpace(), _definition.getName());
        return new ToStringMethod(_definition);
    }
    
    protected MethodExpander createTestAccesorMethod() {
        TestAccessorMethod result = null;
        Type targetType = new Type(getNameSpace(), _definition.getName());
        result = new TestAccessorMethod(targetType, _definition);
        result.setTestData(_testData);
        return result;
    }

    protected FieldTestData createTestData() {
	    return new FieldTestData();
	}
}
