/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct.test;

import blanco.core.datastruct.DataStructDefinition;
import blanco.core.datastruct.DataStructField;
import blanco.core.datastruct.WriteAccessor;
import blanco.core.test.TestCaseImplementor;
import blanco.core.test.TestCaseMethod;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.implementor.StringLiteral;

/**
 * @author Yasuo Nakanishi
 */
public class TestAccessorMethod extends TestCaseMethod {
    private DataStructDefinition _definition = null;
    private FieldTestData _testData = null;
	private TestCaseImplementor _implementor = null;

	public TestAccessorMethod(Type targetType, DataStructDefinition definition){
		super("Accessor", targetType);
		_definition = definition;
		
		_implementor = new TestCaseImplementor(getData());
	}
	
    public void setupSignature() {
        setReturnType(new Type(void.class));
    }

	public void setTestData(FieldTestData testData) {
	    assert testData != null;
	    _testData = testData;
	}

	public void implement() {
		Value expect = new Value(String.class, "expect");
		_implementor.declare(expect, new StringLiteral(getExpectString()));
		_implementor.emptyLine();

        // TODO:RXgN^̈ɑΉKvB
		Value target = new Value(getTargetType(), "target");
		_implementor.declare(target, new Call(getTargetType()));
		for(int i = 0; i < _definition.getFieldCount(); i++) {
		    Receiver r = createSetReceiver(target, _definition.getField(i));
		    _implementor.addStatement(r);
		}

		Call valueCall = new Call("toString");
		valueCall.addArgument(target);
		_implementor.assertEquals(new Statement(expect), valueCall);
	}
	
	public Receiver createSetReceiver(Value target, DataStructField field) {
	    Receiver result = new Receiver(target);
	    Call c = result.call(WriteAccessor.createName(field.getValue()));

	    Statement argument = _testData.getSetterStatement(field);
	    c.addArgument(argument);
	    return result;
	}
	
	public String getExpectString(){
		StringBuffer sb = new StringBuffer();
		
		for(int i = 0; i < _definition.getFieldCount(); i++){
			if(i != 0){
				sb.append(",");
			}
			sb.append(getExpectString(_definition.getField(i)));
		}
		return new String(sb);
	}

	private String getExpectString(DataStructField field){
		StringBuffer sb = new StringBuffer();
		sb.append(field.getValue().getName());
		sb.append(":");
		sb.append(_testData.getExpactStatement(field).toString());
		return new String(sb);
	}
}
