/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.implementor;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/**
 * @author Yasuo Nakanishi
 */
public class ImplementData {
    private List _implementList = null;
    private List _usingTypeList = null;
    private int _indentDepth = 2;
    private Stack _blockStack = new Stack();
    
    public ImplementData() {
        _implementList = new ArrayList();
        _usingTypeList = new ArrayList();
    }

    public ImplementData(List implementList, List usingTypeList) {
        _implementList = implementList;
        _usingTypeList = usingTypeList;
    }
    
    public boolean isEmpty() {
        return _implementList.size() == 0;
    }

    public void pushBlock(Block block) {
        _blockStack.push(block);
    }
    
    public Block getCurrentBlock() {
        return (Block) _blockStack.peek();
    }

	public String indent(String line){
		StringBuffer sb = new StringBuffer(line);
		for(int i = 0; i < _indentDepth; i++){
			sb.insert(0, "\t");
		}
		return new String(sb);
	}

	public void addLine(String line){
		assert line != null;

		if(isBlockEnd(line)){
	        _indentDepth--;
		}
		_implementList.add(indent(line));
		
		if(isBlockStart(line)){
	        _indentDepth++;
		}
		assert _indentDepth >= 2 : "indentDept:" + _indentDepth;
	}

	private boolean isBlockEnd(String line){
		boolean result = false;
		if(line.startsWith("}")){
			result = true;
		}
		return result;
	}

	private boolean isBlockStart(String line){
		boolean result = false;
		if(line.endsWith("{")){
			result = true;
		}
		return result;
	}

	public void popBlock() {
        _blockStack.pop();
    }

    public List getImplementList() {
        return _implementList;
    }

    public List getUsingTypeList() {
        return _usingTypeList;
    }
}
