/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.implementor;

import java.util.List;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * @author Yasuo Nakanishi
 */
public class Implementor {
	private ImplementData _data = null;
    private List _usingTypeList;

	public Implementor(ImplementData data){
	    _usingTypeList = data.getUsingTypeList();
		_data = data;
	}
    
    public void addThrow(Call call) {
        addUsingTypeList(call.getUsingTypeList());
        addStatement("throw " + call.toString());
    }
    
    public void addThrow(Value exception) {
        addStatement("throw " + exception.getName());
    }
    
    public void declare(Value value, Statement defaultStatement) {
        addUsingType(value.getType());
        addUsingTypeList(defaultStatement.getUsingTypeList());

        StringBuffer sb = new StringBuffer();
        sb.append(value.getType().getName());
        sb.append(" ");
        sb.append(value.getName());
        sb.append(" = ");
        sb.append(defaultStatement.toString());

        addStatement(sb.toString());
    }

    public void declare(Value value) {
        addUsingType(value.getType());

        StringBuffer sb = new StringBuffer();
        sb.append(value.getType().getName());
        sb.append(" ");
        sb.append(value.getName());

        addStatement(sb.toString());
    }
    
    public void declareByDefault(Value value) {
        addUsingType(value.getType());

        StringBuffer sb = new StringBuffer();
        sb.append(value.getType().getName());
        sb.append(" ");
        sb.append(value.getName());
        sb.append(" = ");
        sb.append(getDefault(value.getType()));

        addStatement(sb.toString());
    }
    
    private Statement getDefault(Type type) {
        Statement result = null;
        if(type.equals(int.class) || type.equals(short.class)) {
            result = new Statement("0");
        } else if(type.equals(String.class)) {
            result = new StringLiteral("");
        } else if(!type.isPrimitive()) {
            result = new Statement(Value.NULL);
        } else {
            String message = "T|[gǑ^łBType:" + type.getFullName();
            throw new RuntimeException(message);
       }
        return result;
    }

    public void assign(Value value, Statement statement) {
        StringBuffer sb = new StringBuffer();
        sb.append(value.getName());
        sb.append(" = ");
        sb.append(statement.toString());

        addStatement(sb.toString());
        addUsingTypeList(statement.getUsingTypeList());

    }
    
    public void assign(Value value, Value assignValue) {
        assign(value, new Statement(assignValue));
    }
    
	public void emptyLine(){
		addLine("");
	}

	public void openIf(String expresstion){
		_data.pushBlock(Block.IF);
		addLine("if(" + expresstion + "){");
	}

    public void openFor(Statement left, Statement center, Statement right){
        _data.pushBlock(Block.FOR);
        StringBuffer sb = new StringBuffer();
        sb.append("for(");
        sb.append(left.toString());
        sb.append("; ");
        sb.append(center.toString());
        sb.append("; ");
        sb.append(right.toString());
        sb.append(") {");
        addLine(sb.toString());
    }

    public void openFor(Value counter, Statement loop){
        _data.pushBlock(Block.FOR);
        StringBuffer sb = new StringBuffer();
        sb.append("for(");
        sb.append("int ");
        sb.append(counter.getName());
        sb.append(" = 0; ");
        sb.append(loop.toString());
        sb.append("; ");
        sb.append(counter.getName());
        sb.append("++) {");
        addLine(sb.toString());
    }

    public void openWhile(String expresstion){
        _data.pushBlock(Block.WHILE);
        addLine("while(" + expresstion + ") {");
    }

    public void openWhile(Statement expresstion){
        addUsingTypeList(expresstion.getUsingTypeList());
        openWhile(expresstion.toString());
    }

	public void openIf(Statement statement){
	    openIf(statement.toString());
	    addUsingTypeList(statement.getUsingTypeList());
	}

	public void openTry(){
	    _data.pushBlock(Block.TRY);
		addLine("try{");
	}

    public void addElseIf(String expresstion){
        assert _data.getCurrentBlock().equals(Block.IF);
        addLine("} else if(" + expresstion + "){");
    }

    public void addElseIf(Statement expresstion){
        assert _data.getCurrentBlock().equals(Block.IF);
        addUsingTypeList(expresstion.getUsingTypeList());
        addLine("} else if(" + expresstion.toString() + "){");
    }

	public void addCatch(Value value){
		assert _data.getCurrentBlock().equals(Block.TRY);
        addUsingType(value.getType());
		addLine(
				"} catch(" + value.getType().getName() + " " + value.getName() + "){");
	}

	public void addElse(){
		assert _data.getCurrentBlock().equals(Block.IF);
		addLine("} else {");
	}

	public void addFinally(){
		assert _data.getCurrentBlock().equals(Block.TRY);
		addLine("} finally {");
	}
	
	public void closeIf(){
		assert _data.getCurrentBlock().equals(Block.IF);
		_data.popBlock();
		addLine("}");
	}

	public void closeTry(){
		assert _data.getCurrentBlock().equals(Block.TRY);
		_data.popBlock();
		addLine("}");
	}

	public void closeWhile(){
		assert _data.getCurrentBlock().equals(Block.WHILE);
		_data.popBlock();
		addLine("}");
	}

    public void closeFor(){
        assert _data.getCurrentBlock().equals(Block.FOR);
        _data.popBlock();
        addLine("}");
    }

    public void addStatement(String line){
		addLine(line + ";");
	}

	public void addStatement(Statement statement){
		addStatement(statement.toString());
		getUsingTypeList().addAll(statement.getUsingTypeList());
	}

	public void addLine(String line){
	    _data.addLine(line);
	}

	public List getImplementList() {
	    return _data.getImplementList();
	}

	public void addReturn(String value){
		StringBuffer sb = new StringBuffer();
		sb.append("return ");
		sb.append(value);
		sb.append(";");

		addLine(new String(sb));
	}

	public void addReturn(Value value){
	    addReturn(value.getName());
	}

	public void addReturn(Statement statement){
	    addReturn(statement.toString());
		addUsingTypeList(statement.getUsingTypeList());
	}

	public void addReturn(){
		addLine("return;");
	}

    public int getUsingTypeCount(){
        return _usingTypeList.size();
    }
    
    public void addUsingType(Type type){
        _usingTypeList.add(type);
    }

    public void addUsingTypeList(List typeList){
        _usingTypeList.addAll(typeList);
    }

    public Type getUsingType(int index){
        return (Type) _usingTypeList.get(index);
    }

    public List getUsingTypeList() {
        return _usingTypeList;
    }
}
