/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.wsdl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.commons.calc.parser.BlancoCalcParser;

/**
 * ^񂩂璆ԃt@CłXML쐬܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoWsdlMeta2Xml {
    public static void main(String[] args) {
        new File("tmp/telegram").mkdirs();
        // System.out.println("^񂩂XMLt@C쐬: Jn");

        // InputStream inStreamDef = null;
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            // inStreamDef = new FileInputStream(
            // "./src/blanco/wsdl/BlancoWsdlMeta2Xml.xml");
            inStream = new BufferedInputStream(new FileInputStream(
                    "./meta/wsdl/template/blancoWsdlTemplate.xls"));
            outStream = new BufferedOutputStream(new FileOutputStream(
                    "./tmp/telegram/aaa.xml"));

            new BlancoWsdlMeta2Xml().process(inStream, outStream);
            outStream.flush();
            // System.out.println("^񂩂XMLt@C쐬: I");
        } catch (IOException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } finally {
            // if (inStreamDef != null) {
            // try {
            // inStreamDef.close();
            // } catch (IOException e) {
            // e.printStackTrace();
            // }
            // }
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * Excelt@CXMLt@Cɕϊ܂B<br>
     * `t@C͓IɃpXێĂ܂B
     * 
     * @param fileMetaSource
     * @param fileTarget
     * @throws IOException
     * @throws TransformerException
     */
    public void process(InputStream inStreamMetaSource,
            OutputStream outStreamTarget) throws IOException,
            TransformerException {
        InputStream inStreamDef = null;
        try {
            inStreamDef = new BufferedInputStream(getClass().getClassLoader()
                    .getResourceAsStream("blanco/wsdl/BlancoWsdlMeta2Xml.xml"));
            new BlancoCalcParser().process(inStreamDef, inStreamMetaSource,
                    outStreamTarget);
        } finally {
            if (inStreamDef != null)
                inStreamDef.close();
        }
    }
}