/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.xsd;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeFieldStructure;
import blanco.xsd.parser.ComplexTypeStructure;
import blanco.xsd.parser.JavaTypeStructure;
import blanco.xsd.parser.SimpleTypeStructure;

/**
 * blancoWsdl: XSDЂȌ`XML쐬܂B<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdXsd2TemplateXml {

    public static void main(String[] args) {
        try {
            new BlancoXsdXsd2TemplateXml().process("inputSample",
                    "TAAA0001Input", new File(
                            "./tmp/telegram/wsdl/TAAA0001Input.xsd"), new File(
                            "tmp/telegram/wsdl/TAAA0001Input.xsd.xml"));
        } catch (IOException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } catch (SAXException e) {
            e.printStackTrace();
        }
        System.out.println("SĂ̏");
    }

    public void process(final String rootNodeName, final String targetName,
            final File fileSource, final File fileTarget) throws IOException,
            TransformerException, SAXException {
        // xsdp[X܂B
        BlancoXsdParser parser = new BlancoXsdParser();
        final ComplexTypeStructure type = parser
                .process(targetName, fileSource);

        OutputStream outStream = new BufferedOutputStream(new FileOutputStream(
                fileTarget));
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            SAXTransformerFactory saxTf = (SAXTransformerFactory) tf;
            TransformerHandler saxHandler = saxTf.newTransformerHandler();
            saxHandler.setResult(new StreamResult(outStream));
            saxHandler.startDocument();
            saxHandler.startElement("", rootNodeName, rootNodeName,
                    new AttributesImpl());
            expandComplexType(type, saxHandler);
            saxHandler.endElement("", rootNodeName, rootNodeName);
            saxHandler.endDocument();
            outStream.flush();
        } finally {
            outStream.close();
        }
    }

    private void expandComplexType(final ComplexTypeStructure type,
            TransformerHandler saxHandler) throws IOException, SAXException {
        System.out.println("RvbNX^[" + type.getName() + "] TCY["
                + type.getListField().size() + "]");
        for (int index = 0; index < type.getListField().size(); index++) {
            final ComplexTypeFieldStructure objField = (ComplexTypeFieldStructure) type
                    .getListField().get(index);
            if (objField.getTypeStructure() instanceof JavaTypeStructure) {
                JavaTypeStructure typeField = (JavaTypeStructure) objField
                        .getTypeStructure();
                expandJavaType(typeField, objField.getFieldName(), saxHandler);
            } else if (objField.getTypeStructure() instanceof SimpleTypeStructure) {
                SimpleTypeStructure typeField = (SimpleTypeStructure) objField
                        .getTypeStructure();
                expandSimpleType(typeField, objField.getFieldName(), saxHandler);
            } else if (objField.getTypeStructure() instanceof ComplexTypeStructure) {
                ComplexTypeStructure typeField = (ComplexTypeStructure) objField
                        .getTypeStructure();
                int occur = 1;
                if (objField.getMaxOccurs() != null
                        && objField.getMaxOccurs().charAt(0) > '1') {
                    occur = 3;
                }
                for (int indexOccur = 0; indexOccur < occur; indexOccur++) {
                    saxHandler.startElement("", objField.getFieldName(),
                            objField.getFieldName(), new AttributesImpl());
                    expandComplexType(typeField, saxHandler);
                    saxHandler.endElement("", objField.getFieldName(), objField
                            .getFieldName());
                }
            } else {
                throw new IllegalArgumentException("\ȂO܂B^["
                        + objField.getClass().getName() + "]͓͂܂B");
            }
        }
    }

    private void expandSimpleType(final SimpleTypeStructure type,
            final String fieldName, TransformerHandler saxHandler)
            throws IOException, SAXException {
        System.out.println("Vv^[" + type.getName() + "]");
        if (type.getBaseRestriction() != null) {
            expandSimpleType(type.getBaseRestriction(), fieldName, saxHandler);
        } else {
            final JavaTypeStructure typeNew = new JavaTypeStructure();
            typeNew.setName(type.getName());
            typeNew.setTypeOfJava(type.getTypeOfNamespace().substring(
                    "xsd:".length()));
            typeNew.setTypeOfJava(BlancoXsdTypeMapping.xsdType2JavaType(type
                    .getTypeOfNamespace(), "1"));
            System.out.println("name:" + typeNew.getName() + ", type:"
                    + typeNew.getTypeOfJava());
            expandJavaType(typeNew, fieldName, saxHandler);
        }
    }

    /**
     * @param allKnownTypesHashMap
     * @param type
     * @param saxHandler
     * @throws IOException
     * @throws SAXException
     */
    private void expandJavaType(final JavaTypeStructure type,
            final String fieldName, TransformerHandler saxHandler)
            throws IOException, SAXException {
        System.out.println("Java^:" + type.getName());
        saxHandler.startElement("", fieldName, fieldName, new AttributesImpl());
        if (type.getTypeOfJava().equals("java.lang.String")) {
            final char[] value = "".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else if (type.getTypeOfJava().equals("int")
                || type.getTypeOfJava().equals("java.lang.Integer")) {
            final char[] value = "123".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else if (type.getTypeOfJava().equals("long")
                || type.getTypeOfJava().equals("java.lang.Long")) {
            final char[] value = "1234567890".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else if (type.getTypeOfJava().equals("boolean")
                || type.getTypeOfJava().equals("java.lang.Boolean")) {
            final char[] value = "true".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else if (type.getTypeOfJava().equals("java.util.Date")) {
            final char[] value = "2005/12/31".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else {
            throw new IllegalArgumentException("sȌ^[" + type.getTypeOfJava()
                    + "]܂B");
        }
        saxHandler.endElement("", fieldName, fieldName);
        saxHandler.characters("\n".toCharArray(), 0, "\n".toCharArray().length);
    }

}