/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.definition.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.core.datastruct.DataStructField;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class FormField extends DataStructField {

    private String _uiType = "";

    private List _eventList = new ArrayList();

    private FieldValidation _validation = null;

    public FormField(Type type, String name) {
        super(type, name);
    }

    public void setValidation(FieldValidation validation) {
        _validation = validation;
    }

    public FieldValidation getValidation() {
        // assert _validation != null;
        return _validation;
    }

    public void addEvent(String event) {
        _eventList.add(event);
    }

    public Iterator getEventIterator() {
        return _eventList.iterator();
    }

    public String getUiType() {
        return _uiType;
    }

    public void setUiType(String uiType) {
        _uiType = uiType;
    }
}
