/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.expander.action;

import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.AbstractMethod;
import blanco.struts.definition.form.Form;
import blanco.struts.definition.form.FormEvent;

/**
 * @author Yasuo Nakanishi
 */
public class EventMethod extends AbstractMethod {
    private Type _formType = null;

    private Form _form = null;

    private FormEvent _event = null;

    public EventMethod(FormEvent event, Type formType, Form form) {
        super(createEventName(event.getName()));
        _event = event;
        _formType = formType;
        _form = form;
    }

    public static String createEventName(String event) {
        String result = "";
        if (event.equals("init")) {
            result = event;
        } else if (event.equals("load")) {
            result = "onLoad";
        } else {
            result = "onClick" + getNameAdjuster().toTitleCase(event);
        }
        return result;
    }

    public void setupSignature() {

        setScope(Scope.PROTECTED);

        if (getName().equals("init")) {
            setReturnType(new Type(void.class));
        } else {
            setReturnType(new Type("org.apache.struts.action.ActionForward"));
        }

        getJavaDoc().addParameter("mapping", "ActionMappingIuWFNgB");
        addArgument(new Value(
                new Type("org.apache.struts.action.ActionMapping"), "mapping"));
        // tH[͎֘AۃNXZbg܂B
        getJavaDoc().addParameter("form",
                "Strutsn Form [" + _formType.getFullName() + "] IuWFNgB");
        addArgument(new Value(_formType, "form"));
        getJavaDoc().addParameter("request", "Servlet瓾requestIuWFNgB");
        addArgument(new Value(
                new Type("javax.servlet.http.HttpServletRequest"), "request"));
        getJavaDoc().addParameter("response", "Servlet瓾responseIuWFNgB");
        addArgument(new Value(
                new Type("javax.servlet.http.HttpServletResponse"), "response"));
        if (_form.isUsingDb()) {
            getJavaDoc().addParameter("connection", "f[^x[XڑIuWFNgB");
            addArgument(new Value(new Type("java.sql.Connection"), "connection"));
        }

        addException(Exception.class);

        String doc = "";
        if (!_event.getDescription().equals("")) {
            doc = _event.getDescription() + "Cxg邽߂̃\bhB";
        } else {
            doc = getName() + " Cxg邽߂̃\bhB";
        }
        getJavaDoc().addLine(doc);

        getJavaDoc().addLine("̃\bh͒ۃ\bhłBۂɂ̓TuNXŎĂB");
    }

    public static String getParameterName(Class parameter) {
        String className = new Type(parameter).getName();
        String[] names = className.replaceAll("[A-Z]", " $0").split("\\s");
        return names[names.length - 1].toLowerCase();
    }

}
