/*
 * blancoIg
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.expander.action;

import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.AbstractMethod;
import blanco.struts.definition.form.Form;
import blanco.struts.definition.form.FormEvent;

/**
 * @author Tosiki Iga
 */
public class FoundInvalidTokenMethod extends AbstractMethod {
    private Type _formType = null;

    private Form _form = null;

    private FormEvent _event = null;

    public FoundInvalidTokenMethod(FormEvent event, Type formType, Form form) {
        super("foundInvalidTokenOnClick"
                + getNameAdjuster().toTitleCase(event.getName()));
        _event = event;
        _formType = formType;
        _form = form;

        addArgument(new Value(
                new Type("org.apache.struts.action.ActionMapping"), "mapping"));
        // tH[͎֘AۃNXZbg܂B
        addArgument(new Value(_formType, "form"));
        addArgument(new Value(
                new Type("javax.servlet.http.HttpServletRequest"), "request"));
        addArgument(new Value(
                new Type("javax.servlet.http.HttpServletResponse"), "response"));
        if (_form.isUsingDb()) {
            addArgument(new Value(new Type("java.sql.Connection"), "connection"));
        }

        addException(Exception.class);
    }

    public void setupSignature() {

        setScope(Scope.PROTECTED);

        setReturnType(new Type("org.apache.struts.action.ActionForward"));
    }

    public static String getParameterName(Class parameter) {
        String className = new Type(parameter).getName();
        String[] names = className.replaceAll("[A-Z]", " $0").split("\\s");
        return names[names.length - 1].toLowerCase();
    }
}
