/*
 * blancoStruts Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.struts.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.struts.BlancoStrutsMeta2Xml;
import blanco.struts.BlancoStrutsXml2JavaClass;

/**
 * BlancoStruts Ant Task
 */
public class BlancoStrutsTask extends Task {

    private String metadir = null
    ;
	private String tmpdir = null;
	
	private String targetdir = null;
	
	private String runtimepackage = null;
	
    private boolean runtime;

    public void execute() throws BuildException {
		
        System.out.println("blancoStruts ^XN");
        System.out.println("blancoStruts\[XR[h");
    
        if (runtimepackage == null) {
            throw new BuildException("runtimepackagew肵ĂB");
        }
        if (metadir == null) {
            throw new BuildException("metadirw肵ĂB");
        }
        if (tmpdir == null) {
            // e|tH_̎w肪Ȃꍇɂ́AJgtmpp܂B
            tmpdir = "tmp";
        }
        if (targetdir == null) {
            // e|tH_̎w肪Ȃꍇɂ́AJgblancop܂B
			targetdir = "blanco/main";
        }
		
		try{
			System.out.println("fBNg: e|tH_̒B");
            File blancoTmpDirectory = new File(tmpdir + "/struts");
			if(blancoTmpDirectory.exists()){
			    // e|tH_U폜܂B
				blancoTmpDirectory.delete();
			}
			blancoTmpDirectory.mkdirs();
			
            File blancoMetaDirectory = new File(metadir);
			final File[] files = blancoMetaDirectory.listFiles();
            if (files != null) {
				System.out.println("Excelt@CXMLt@C܂B");
                for (int index = 0; index < files.length; index++) {
                    // Excelt@CXMLt@C܂B
                    if (files[index].getName().endsWith(".xls") == false) {
                        continue;
                    }
					
		            InputStream inStream = null;
		            OutputStream outStream = null;
		            try {
		                inStream = new BufferedInputStream(
								new FileInputStream(
										blancoMetaDirectory + "/"
                                        + files[index].getName()));
		                outStream = new BufferedOutputStream(
		                        new FileOutputStream(
										blancoTmpDirectory + "/"
                                        + files[index].getName()
                                        + ".xml"));
		                new BlancoStrutsMeta2Xml().process(
		                        inStream, outStream);
		                outStream.flush();
		            } finally {
		                if (inStream != null) {
		                    inStream.close();
		                }
		                if (outStream != null) {
		                    outStream.close();
		                }
		            }
                }
				
				System.out.println("^[QbgfBNg̍쐬B");
	            File blancoTargetDirectory = new File(targetdir);
				if(blancoTargetDirectory.exists()){
					blancoTargetDirectory.delete();
				}
				blancoTargetDirectory.mkdirs();

				final File[] xmlfiles = blancoTmpDirectory.listFiles();
	            if (xmlfiles != null) {
					System.out.println("XMLt@CJava\[XR[h܂B");
	                for (int index = 0; index < xmlfiles.length; index++) {
	                    // XMLt@CJavat@C܂B
	                    if (xmlfiles[index].getName().endsWith(".xml") == false) {
	                        continue;
	                    }
                        new BlancoStrutsXml2JavaClass()
                        .process(
								xmlfiles[index],
                                blancoTargetDirectory,
								runtimepackage,
                                runtime);
	                }
					
	            }
            }
			

        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("rhɗO: rh𒆒f܂: " + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("rhɃG[: rh𒆒f܂: " + e.toString());
        }
    

    }

	/**
	 * @return Returns the metadir.
	 */
	public String getMetadir() {
		return metadir;
	}

	/**
	 * @param metadir The metadir to set.
	 */
	public void setMetadir(String metadir) {
		this.metadir = metadir;
	}

	/**
	 * @return Returns the runtime.
	 */
	public boolean isRuntime() {
		return runtime;
	}

	/**
	 * @param runtime The runtime to set.
	 */
	public void setRuntime(boolean runtime) {
		this.runtime = runtime;
	}

	/**
	 * @return Returns the runtimepackage.
	 */
	public String getRuntimepackage() {
		return runtimepackage;
	}

	/**
	 * @param runtimepackage The runtimepackage to set.
	 */
	public void setRuntimepackage(String runtimepackage) {
		this.runtimepackage = runtimepackage;
	}

	/**
	 * @return Returns the targetdir.
	 */
	public String getTargetdir() {
		return targetdir;
	}

	/**
	 * @param targetdir The targetdir to set.
	 */
	public void setTargetdir(String targetdir) {
		this.targetdir = targetdir;
	}

	/**
	 * @return Returns the tmpdir.
	 */
	public String getTmpdir() {
		return tmpdir;
	}

	/**
	 * @param tmpdir The tmpdir to set.
	 */
	public void setTmpdir(String tmpdir) {
		this.tmpdir = tmpdir;
	}
	
}
