/*
 * blancoStruts Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.struts.util;

import java.io.File;
import java.io.IOException;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import blanco.ig.expander.ClassExpander;
import blanco.ig.generator.GeneratorSetting;
import blanco.ig.generator.ImplementGenerator;
import blanco.ig.service.ServiceClass;

public class BlancoStrutsExpandUtil {
    /**
     * Gg當ǂݍ݂܂B
     * 
     * @param elementTarget
     * @param tagName
     * @return
     */
    public static final String readStringByElementTagName(
            Element elementTarget, String tagName) {
        String result = null;
        NodeList listElementTarget = elementTarget
                .getElementsByTagName(tagName);
        int sizeList = listElementTarget.getLength();
        for (int index = 0; index < sizeList; index++) {
            Node nodeLook = listElementTarget.item(index);
            if (nodeLook instanceof Element) {
                Element elementLook = (Element) nodeLook;

                NodeList listText = elementLook.getChildNodes();
                int sizeChildList = listText.getLength();
                for (int indexChild = 0; indexChild < sizeChildList; indexChild++) {
                    Node nodeChild = listText.item(indexChild);
                    if (nodeChild instanceof Text) {
                        Text textLook = (Text) nodeChild;
                        result = (result == null ? textLook.getData() : result
                                + textLook.getData());
                    }
                }
            }
        }
        return result;
    }

    public static void generateJavaSource(ClassExpander classExpander,
            File directoryTarget) {
        GeneratorSetting setting = new GeneratorSetting();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(directoryTarget.getAbsolutePath());
        ImplementGenerator implementGenerator = new ImplementGenerator(
                new ServiceClass("DummyService"), setting);
        // 쐬NXo^܂B
        implementGenerator.addMain(classExpander);
        try {
            // ۂɃ\[XR[hs܂B
            implementGenerator.generate();
            System.out.println("\[XR[h܂B");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * ͂JavaƍlăGXP[v܂B<br>
     * CWFNVUɂ͑ΉĂ܂B
     * 
     * @param arg
     * @return
     */
    public static String escapeStringAsJavaSource(String arg) {
        return arg.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
    }
}
