/*
 * blancoDb
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.sql.SQLException;
import java.util.Iterator;

import blanco.db.definition.QueryCaller;
import blanco.db.mapping.BlancoDbMappingUtil;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.db.util.BlancoDbQueryParserUtil;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author tosiki iga
 */
public class PrepareCallMethod2 extends MethodExpander {
    BlancoDbObjectStorage storage = null;

    private QueryCaller _caller = null;

    private Value queryArgument = new Value(String.class, "query");

    public PrepareCallMethod2(final BlancoDbObjectStorage storage,
            final QueryCaller caller) {
        super("prepareCall");
        this.storage = storage;
        _caller = caller;
    }

    public void setupSignature() {
        // ǉĂ݂B
        addArgument(queryArgument);
        addException(SQLException.class);

        getJavaDoc().addLine("NG̃vRpC{܂B<br>");
        getJavaDoc().addLine(
                "Iɓeω悤SQLsKvꍇɂ̂݁Ã\bh𗘗p܂B<br>");
        getJavaDoc()
                .addLine(
                        "SQL̂̂p[^Ƃė^邱ƂłĎRxASQLCWFNVƌĂ΂ZLeBz[댯_ɒӂŗpĂB<br>");
        getJavaDoc().addLine("Iɂ Connection.prepareCall Ăяo܂B");
        getJavaDoc().addParameter("query", "pNG(SQL)");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName()
                    + ": query = \" + query);");
            implementor.addLine("}");
            implementor.addLine("");
        }

        implementor.addStatement("close()");

        implementor.addStatement("fStatement = fConnection.prepareCall(query)");

        final BlancoDbQueryParserUtil query = new BlancoDbQueryParserUtil(
                _caller.getQuery());

        final Iterator ite = _caller.getOutParameterIterator();
        while (ite.hasNext()) {
            // AƂ肠^ꂽœoƉ肪Ă܂B
            final Value val = (Value) ite.next();

            final int[] listCol = query.getSqlParameters(val.getName());
            if (listCol == null) {
                System.out.println("[" + _caller.getName() + "] SQLo̓p[^["
                        + val.getName() + "]тĂ܂.");
                continue;
            }
            for (int iteSame = 0; iteSame < listCol.length; iteSame++) {
                final int index = listCol[iteSame];

                String stmtLine = "fStatement.registerOutParameter("
                        + index
                        + ", "
                        + BlancoDbMappingUtil.convertJavaTypeToJdbcType(val
                                .getType().getFullName());
                stmtLine += ")";
                implementor.addStatement(stmtLine);
            }
        }
    }
}