/*
 * blancoDb Enterprise Edition Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.db.mapping;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Date;

public final class BlancoDbMappingUtil {

    /**
     * Java^ɁAResultSetɑ΂Qb^[\bh擾܂B
     * 
     * @author tosiki iga
     * @since 2005.05.03
     * @param javaTypeName
     *            Javǎ^
     * @return
     */
    public static final String getResultSetGetterMethodName(
            final String javaTypeName) {
        String setAccessorName = "";
        if (javaTypeName.equals("int")) {
            setAccessorName = "getInt";
        } else if (javaTypeName.equals("byte")) {
            setAccessorName = "getByte";
        } else if (javaTypeName.equals("short")) {
            setAccessorName = "getShort";
        } else if (javaTypeName.equals("long")) {
            setAccessorName = "getLong";
        } else if (javaTypeName.equals("boolean")) {
            setAccessorName = "getBoolean";
        } else if (javaTypeName.equals("float")) {
            setAccessorName = "getFloat";
        } else if (javaTypeName.equals("double")) {
            setAccessorName = "getDouble";
        } else if (javaTypeName.equals("String")) {
            setAccessorName = "getString";
        } else if (javaTypeName.equals("Date")) {
            setAccessorName = "getTimestamp";
        } else if (javaTypeName.equals("BigDecimal")) {
            setAccessorName = "getBigDecimal";
        } else if (javaTypeName.equals("Integer")) {
            setAccessorName = "getInt";
        } else if (javaTypeName.equals("Byte")) {
            setAccessorName = "getByte";
        } else if (javaTypeName.equals("Short")) {
            setAccessorName = "getShort";
        } else if (javaTypeName.equals("Long")) {
            setAccessorName = "getLong";
        } else if (javaTypeName.equals("Boolean")) {
            setAccessorName = "getBoolean";
        } else if (javaTypeName.equals("Float")) {
            setAccessorName = "getFloat";
        } else if (javaTypeName.equals("Double")) {
            setAccessorName = "getDouble";
        } else if (javaTypeName.equals("InputStream")) {
            setAccessorName = "getBinaryStream";
        } else if (javaTypeName.equals("Reader")) {
            setAccessorName = "getCharacterStream";
        } else {
            throw new IllegalArgumentException("Qb^[擾鏈ŁA^[" + javaTypeName
                    + "]ɑΉQb^[̉͂Ɏs܂B");
        }

        return setAccessorName;
    }

    /**
     * Java^ɁAPreparedStatementɑ΂Zb^[\bh擾܂B
     * 
     * @author tosiki iga
     * @since 2005.05.03
     * @param javaTypeName
     *            Javǎ^
     * @return
     */
    public static final String getPreparedStatementSetterMethodName(
            final String javaTypeName) {
        String setAccessorName = "";
        if (javaTypeName.equals("int")) {
            setAccessorName = "setInt";
        } else if (javaTypeName.equals("byte")) {
            setAccessorName = "setByte";
        } else if (javaTypeName.equals("short")) {
            setAccessorName = "setShort";
        } else if (javaTypeName.equals("long")) {
            setAccessorName = "setLong";
        } else if (javaTypeName.equals("boolean")) {
            setAccessorName = "setBoolean";
        } else if (javaTypeName.equals("float")) {
            setAccessorName = "setFloat";
        } else if (javaTypeName.equals("double")) {
            setAccessorName = "setDouble";
        } else if (javaTypeName.equals("String")) {
            setAccessorName = "setString";
        } else if (javaTypeName.equals("Date")) {
            setAccessorName = "setTimestamp";
        } else if (javaTypeName.equals("BigDecimal")) {
            setAccessorName = "setBigDecimal";
        } else if (javaTypeName.equals("Integer")) {
            setAccessorName = "setInt";
        } else if (javaTypeName.equals("Short")) {
            setAccessorName = "setShort";
        } else if (javaTypeName.equals("Byte")) {
            setAccessorName = "setByte";
        } else if (javaTypeName.equals("Long")) {
            setAccessorName = "setLong";
        } else if (javaTypeName.equals("Boolean")) {
            setAccessorName = "setBoolean";
        } else if (javaTypeName.equals("Float")) {
            setAccessorName = "setFloat";
        } else if (javaTypeName.equals("Double")) {
            setAccessorName = "setDouble";
        } else if (javaTypeName.equals("InputStream")) {
            setAccessorName = "setBinaryStream";
        } else if (javaTypeName.equals("Reader")) {
            setAccessorName = "setCharacterStream";
        } else {
            throw new IllegalArgumentException("Zb^[擾鏈ŁA^[" + javaTypeName
                    + "]ɑΉZb^[̉͂Ɏs܂B");
        }

        return setAccessorName;
    }

    /**
     * KȒlpreparedStatementɃZbgs܂B <br>
     * TODO: KȒlƂ̂A0ł悢̂ǂ͍čl̕KvB1̉\łB
     * 
     * @throws SQLException
     */
    public static final void processPreparedStatementWithSomeValue(
            final String javaTypeName, final PreparedStatement stmt,
            final int columnId) throws SQLException {
        if (javaTypeName.equals("int")) {
            stmt.setInt(columnId, 0);
        } else if (javaTypeName.equals("byte")) {
            stmt.setByte(columnId, (byte) 0x00);
        } else if (javaTypeName.equals("short")) {
            stmt.setShort(columnId, (short) 0);
        } else if (javaTypeName.equals("long")) {
            stmt.setLong(columnId, 0);
        } else if (javaTypeName.equals("boolean")) {
            stmt.setBoolean(columnId, false);
        } else if (javaTypeName.equals("float")) {
            stmt.setFloat(columnId, 0);
        } else if (javaTypeName.equals("double")) {
            stmt.setDouble(columnId, 0);
        } else if (javaTypeName.equals("String")) {
            stmt.setString(columnId, "");
        } else if (javaTypeName.equals("Date")) {
            stmt.setTimestamp(columnId, new Timestamp(0));
        } else if (javaTypeName.equals("BigDecimal")) {
            // BigDecimal(int) J2SE 1.5瓱ꂽ\bhłB
            // "0"ƖIɕƂĎw肵Ă܂B
            stmt.setBigDecimal(columnId, new BigDecimal("0"));
        } else if (javaTypeName.equals("Integer")) {
            stmt.setInt(columnId, 0);
        } else if (javaTypeName.equals("Byte")) {
            stmt.setByte(columnId, (byte) 0x00);
        } else if (javaTypeName.equals("Short")) {
            stmt.setShort(columnId, (short) 0);
        } else if (javaTypeName.equals("Long")) {
            stmt.setLong(columnId, 0);
        } else if (javaTypeName.equals("Boolean")) {
            stmt.setBoolean(columnId, false);
        } else if (javaTypeName.equals("Float")) {
            stmt.setFloat(columnId, 0);
        } else if (javaTypeName.equals("Double")) {
            stmt.setDouble(columnId, 0);
        } else if (javaTypeName.equals("InputStream")) {
            byte[] dummy = "0".getBytes();
            stmt.setBinaryStream(columnId, new ByteArrayInputStream(dummy),
                    dummy.length);
        } else if (javaTypeName.equals("Reader")) {
            char[] dummy = new char[1];
            dummy[0] = '0';
            stmt.setCharacterStream(columnId, new CharArrayReader(dummy),
                    dummy.length);
        } else {
            throw new IllegalArgumentException("_~[loCh鏈ɂāA^["
                    + javaTypeName + "]ɑΉZb^[̉͂Ɏs܂B");
        }
    }

    public static final String getResultSetUpdateMethodName(
            final String javaTypeName) {
        String setAccessorName = "";
        if (javaTypeName.equals("int")) {
            setAccessorName = "updateInt";
        } else if (javaTypeName.equals("byte")) {
            setAccessorName = "updateByte";
        } else if (javaTypeName.equals("short")) {
            setAccessorName = "updateShort";
        } else if (javaTypeName.equals("long")) {
            setAccessorName = "updateLong";
        } else if (javaTypeName.equals("boolean")) {
            setAccessorName = "updateBoolean";
        } else if (javaTypeName.equals("float")) {
            setAccessorName = "updateFloat";
        } else if (javaTypeName.equals("double")) {
            setAccessorName = "updateDouble";
        } else if (javaTypeName.equals("String")) {
            setAccessorName = "updateString";
        } else if (javaTypeName.equals("Date")) {
            setAccessorName = "updateTimestamp";
        } else if (javaTypeName.equals("BigDecimal")) {
            setAccessorName = "updateBigDecimal";
        } else if (javaTypeName.equals("Integer")) {
            setAccessorName = "updateInt";
        } else if (javaTypeName.equals("Byte")) {
            setAccessorName = "updateByte";
        } else if (javaTypeName.equals("Short")) {
            setAccessorName = "updateShort";
        } else if (javaTypeName.equals("Long")) {
            setAccessorName = "updateLong";
        } else if (javaTypeName.equals("Boolean")) {
            setAccessorName = "updateBoolean";
        } else if (javaTypeName.equals("Float")) {
            setAccessorName = "updateFloat";
        } else if (javaTypeName.equals("Double")) {
            setAccessorName = "updateDouble";
        } else if (javaTypeName.equals("InputStream")) {
            setAccessorName = "updateBinaryStream";
        } else if (javaTypeName.equals("Reader")) {
            setAccessorName = "updateCharacterStream";
        } else {
            throw new IllegalArgumentException("update\bhɂ郁\bhm菈ɂāA^["
                    + javaTypeName + "]ɑΉupdate\bh̉͂Ɏs܂B");
        }
        return setAccessorName;
    }

    /**
     * bp[NXΉKvǂ𔻒肵܂B
     * 
     * @param javaTypeName
     *            ZJava̖ FInteger
     * @return
     */
    public static final boolean isMapWrapperClassNecessity(
            final String javaTypeName) {
        if (javaTypeName.equals("Integer") || javaTypeName.equals("Byte")
                || javaTypeName.equals("Short") || javaTypeName.equals("Long")
                || javaTypeName.equals("Float")
                || javaTypeName.equals("Double")
                || javaTypeName.equals("Boolean")
                || javaTypeName.equals("Date")) {
            return true;
        }
        return false;
    }

    /**
     * Kvȏꍇ̂݁Av~eBu^ɑ΂ăbp[NXbsO܂B
     * 
     * @param String
     *            originalLine IWis
     * @param String
     *            javaTypeName Javǎ^
     * @return
     */
    public static final String mapWrapperClassForPrimitive(
            final String originalLine, final String javaTypeName) {
        String converter1 = "";
        String converter2 = "";
        if (javaTypeName.equals("Date")) {
            // Datȅꍇɂ ResultSetTimestampnĂ܂B
            converter1 = "BlancoDbUtil.convertTimestampToDate(";
            converter2 = ")";
        } else if (javaTypeName.equals("Byte")) {
            converter1 = "new Byte(";
            converter2 = ")";
        } else if (javaTypeName.equals("Short")) {
            converter1 = "new Short(";
            converter2 = ")";
        } else if (javaTypeName.equals("Integer")) {
            converter1 = "new Integer(";
            converter2 = ")";
        } else if (javaTypeName.equals("Long")) {
            converter1 = "new Long(";
            converter2 = ")";
        } else if (javaTypeName.equals("Boolean")) {
            converter1 = "new Boolean(";
            converter2 = ")";
        } else if (javaTypeName.equals("Double")) {
            converter1 = "new Double(";
            converter2 = ")";
        } else if (javaTypeName.equals("Float")) {
            converter1 = "new Float(";
            converter2 = ")";
        }
        return converter1 + originalLine + converter2;
    }

    /**
     * bp[NXv~eBuɕϊ܂B
     * 
     * @param originalLine
     * @param javaTypeName
     * @return
     */
    public static final String mapWrapperClassIntoPrimitive(
            final String originalLine, final String javaTypeName) {
        String converter1 = "";
        String converter2 = "";
        if (javaTypeName.equals("Date")) {
            converter1 = "new Timestamp(";
            converter2 = ".getTime())";
        } else if (javaTypeName.equals("Byte")) {
            converter1 = "";
            converter2 = ".byteValue()";
        } else if (javaTypeName.equals("Short")) {
            converter1 = "";
            converter2 = ".shortValue()";
        } else if (javaTypeName.equals("Integer")) {
            converter1 = "";
            converter2 = ".intValue()";
        } else if (javaTypeName.equals("Long")) {
            converter1 = "";
            converter2 = ".longValue()";
        } else if (javaTypeName.equals("Boolean")) {
            converter1 = "";
            converter2 = ".booleanValue()";
        } else if (javaTypeName.equals("Double")) {
            converter1 = "";
            converter2 = ".doubleValue()";
        } else if (javaTypeName.equals("Float")) {
            converter1 = "";
            converter2 = ".floatValue()";
        }
        return converter1 + originalLine + converter2;
    }

    public final static String convertJdbcTypeToString(final int jdbcType) {
        final String TYPES_BASE = "java.sql.Types.";
        switch (jdbcType) {
        case Types.BIT:
            return TYPES_BASE + "BIT";
        case Types.TINYINT:
            return TYPES_BASE + "TINYINT";
        case Types.SMALLINT:
            return TYPES_BASE + "SMALLINT";
        case Types.INTEGER:
            return TYPES_BASE + "INTEGER";
        case Types.BIGINT:
            return TYPES_BASE + "BIGINT";
        case Types.FLOAT:
            return TYPES_BASE + "FLOAT";
        case Types.REAL:
            return TYPES_BASE + "REAL";
        case Types.DOUBLE:
            return TYPES_BASE + "DOUBLE";
        case Types.NUMERIC:
            return TYPES_BASE + "NUMERIC";
        case Types.DECIMAL:
            return TYPES_BASE + "DECIMAL";
        case Types.CHAR:
            return TYPES_BASE + "CHAR";
        case Types.VARCHAR:
            return TYPES_BASE + "VARCHAR";
        case Types.LONGVARCHAR:
            return TYPES_BASE + "LONGVARCHAR";
        case Types.DATE:
            return TYPES_BASE + "DATE";
        case Types.TIME:
            return TYPES_BASE + "TIME";
        case Types.TIMESTAMP:
            return TYPES_BASE + "TIMESTAMP";
        case Types.BINARY:
            return TYPES_BASE + "BINARY";
        case Types.VARBINARY:
            return TYPES_BASE + "VARBINARY";
        case Types.LONGVARBINARY:
            return TYPES_BASE + "LONGVARBINARY";
        case Types.NULL:
            return TYPES_BASE + "NULL";
        case Types.OTHER:
            return TYPES_BASE + "OTHER";
        case Types.JAVA_OBJECT:
            return TYPES_BASE + "JAVA_OBJECT";
        case Types.DISTINCT:
            return TYPES_BASE + "DISTINCT";
        case Types.STRUCT:
            return TYPES_BASE + "STRUCT";
        case Types.ARRAY:
            return TYPES_BASE + "ARRAY";
        case Types.BLOB:
            return TYPES_BASE + "BLOB";
        case Types.CLOB:
            return TYPES_BASE + "CLOB";
        case Types.REF:
            return TYPES_BASE + "REF";
        case Types.DATALINK:
            // since 1.4
            return TYPES_BASE + "DATALINK";
        case Types.BOOLEAN:
            // since 1.4
            return TYPES_BASE + "BOOLEAN";
        default:
            // s\
            System.out.println("JDBC^Cv[" + jdbcType + "]͖T|[gł.");
            return "java.sql.Types.OTHER";
        }
    }

    public final static String convertJavaTypeToJdbcType(
            final String javaFullType) {
        final String TYPES_BASE = "java.sql.Types.";
        if (javaFullType.equals("java.lang.Boolean")) {
            return TYPES_BASE + "BIT";
            // return TYPES_BASE + "BOOLEAN";
        } else if (javaFullType.equals("java.lang.Byte")) {
            return TYPES_BASE + "TINYINT";
        } else if (javaFullType.equals("java.lang.Short")) {
            return TYPES_BASE + "SMALLINT";
        } else if (javaFullType.equals("java.lang.Integer")) {
            return TYPES_BASE + "INTEGER";
        } else if (javaFullType.equals("java.lang.Long")) {
            return TYPES_BASE + "BIGINT";
        } else if (javaFullType.equals("java.lang.Float")) {
            return TYPES_BASE + "REAL";
        } else if (javaFullType.equals("java.lang.Double")) {
            return TYPES_BASE + "DOUBLE";
        } else if (javaFullType.equals("java.math.BigDecimal")) {
            return TYPES_BASE + "DECIMAL";
        } else if (javaFullType.equals("java.lang.String")) {
            return TYPES_BASE + "VARCHAR";
        } else if (javaFullType.equals("java.io.Reader")) {
            return TYPES_BASE + "LONGVARCHAR";
        } else if (javaFullType.equals("java.util.Date")) {
            return TYPES_BASE + "TIMESTAMP";
        } else if (javaFullType.equals("java.io.InputStream")) {
            return TYPES_BASE + "VARBINARY";
        } else {
            System.out.println("JDBC^Cv[" + javaFullType + "]͖T|[gł.");
            return "java.sql.Types.OTHER";
        }
    }

    /**
     * java.sql.ResultSetMetaDatã^Cvnull̗L JavãNX}bsO܂B
     * 
     * ۂJDBC^JavaNXւƃ}bsOsĂAblancoDb̒ŏdvȏłB
     * 
     * @param dataType
     *            ResultSetMetaData.getColumnType()܂
     *            resultSet.getInt("DATA_TYPE")œl
     * @param isColumnNoNulls
     *            NULL񂪂邩ǂBResultSetMetaData.isNullable()܂
     *            resultSet.getInt("NULLABLE")œl
     * @return oꂽJavǎ^BoȂꍇɂnull߂܂B
     */
    public static final Class mapResultSetMeta2JavaClass(final int dataType,
            final boolean isColumnNoNulls) {
        switch (dataType) {
        case java.sql.Types.CHAR:
        case java.sql.Types.VARCHAR:
            return String.class;
        case java.sql.Types.LONGVARCHAR:
            return java.io.Reader.class;
        case java.sql.Types.DATE:
        case java.sql.Types.TIME:
        case java.sql.Types.TIMESTAMP:
            return Date.class;
        case java.sql.Types.REAL:
            if (isColumnNoNulls) {
                return float.class;
            } else {
                return Float.class;
            }
        case java.sql.Types.FLOAT:
        case java.sql.Types.DOUBLE:
            if (isColumnNoNulls) {
                return double.class;
            } else {
                return Double.class;
            }
        case java.sql.Types.DECIMAL:
        case java.sql.Types.NUMERIC:
            // DECIMALNUMERICƂ̍ق́ASuñ}bv\ɂ͌Ȃ
            return BigDecimal.class;
        case java.sql.Types.INTEGER:
            if (isColumnNoNulls) {
                return int.class;
            } else {
                return Integer.class;
            }
        case java.sql.Types.BIGINT:
            if (isColumnNoNulls) {
                return long.class;
            } else {
                return Long.class;
            }
        case java.sql.Types.SMALLINT:
            if (isColumnNoNulls) {
                return short.class;
            } else {
                return Short.class;
            }
        case java.sql.Types.TINYINT:
            if (isColumnNoNulls) {
                return byte.class;
            } else {
                return Byte.class;
            }
        case java.sql.Types.BIT:
            if (isColumnNoNulls) {
                return boolean.class;
            } else {
                return Boolean.class;
            }
        case java.sql.Types.BINARY:
        case java.sql.Types.LONGVARBINARY:
            return InputStream.class;
        default:
            return null;
        }
    }

    /**
     * ^CvJavaNXĂ܂B
     * 
     * mapResultSetMeta2JavaClass\bhg
     * ResultSetMetaData^ĂȂꍇɌĂяo܂B
     * ۂJDBC^JavaNXւƃ}bsOsĂAblancoDb̒ŏdvȏłB
     * 
     * @param typeName
     * @param isColumnNoNulls
     *            ݂͏ŗpĂ܂B
     *            NULL񂪂邩ǂBResultSetMetaData.isNullable()܂
     *            resultSet.getInt("NULLABLE")œl
     * @return oꂽJavǎ^BoȂꍇɂnull߂܂B
     */
    public static final Class mapTypeName2JavaClass(final String typeName,
            final boolean isColumnNoNulls) {
        String wrkTypeName = typeName.toUpperCase();
        int indexOfTrim = wrkTypeName.indexOf('(');
        if (indexOfTrim > 0) {
            wrkTypeName = wrkTypeName.substring(0, indexOfTrim);
        }

        if (wrkTypeName.equals("TIMESTAMP")) {
            return Date.class;
        } else {
            return null;
        }
    }
}
