/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.exception;

/**
 * f[^x[X̏̌ʁA1s𒴂f[^XVĂ܂ƂONX <br>
 * ̃NXblancoDb\[XR[hŗp܂ <br>
 * ̃NX́A\[XR[h̃t@CƂėp܂B
 * 
 * @since 2005.05.12
 * @author Tosiki Iga
 */
public class TooManyRowsFoundException extends NotSingleRowException {
    /**
     * SQLState͉̒lƂĐݒ肵Ă܂B <br>
     * vO SQLStateɗ炸 ONXɂĔf悤ɂĂB
     */
    private static final String SQLSTATE_TOOMANYROWSFOUND = "00111";

    /**
     * f[^x[X̏̌ʁA1s𒴂f[^XVĂ܂ƂONX <br>
     * 
     * @deprecated Ri[邱Ƃłʂ̃RXgN^𗘗p邱ƂE߂܂B
     */
    public TooManyRowsFoundException() {
        super("Too many rows found exception has occured.",
                SQLSTATE_TOOMANYROWSFOUND);
    }

    /**
     * f[^x[X̏̌ʁA1s𒴂f[^XVĂ܂ƂONX <br>
     * 
     * @param reason
     *            O̐
     */
    public TooManyRowsFoundException(final String reason) {
        super(reason, SQLSTATE_TOOMANYROWSFOUND);
    }

    /**
     * f[^x[X̏̌ʁA1s𒴂f[^XVĂ܂ƂONX <br>
     * 
     * @param reason
     *            O̐
     * @param SQLState
     *            Oʂ XOPENR[h܂ SQL 99̃R[h
     */
    public TooManyRowsFoundException(final String reason, final String SQLState) {
        super(reason, SQLState);
    }

    /**
     * f[^x[X̏̌ʁA1s𒴂f[^XVĂ܂ƂONX <br>
     * 
     * @param reason
     *            O̐
     * @param SQLState
     *            Oʂ XOPENR[h܂ SQL 99̃R[h
     * @param vendorCode
     *            f[^x[Xx_[߂ŗL̗OR[h
     */
    public TooManyRowsFoundException(final String reason,
            final String SQLState, final int vendorCode) {
        super(reason, SQLState, vendorCode);
    }
}