/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.SQLException;

import blanco.db.definition.QueryIterator;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class ExecuteQueryMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private Value _resultSet = null;

    private Value _statement = null;

    public ExecuteQueryMethod(final BlancoDbObjectStorage storage,
            final QueryIterator iterator) {
        super("executeQuery");
        this.storage = storage;
    }

    public void setupSignature() {
        addException(SQLException.class);

        getJavaDoc().addLine("^NGs܂B<br>");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        _statement = getField("fStatement");
        _resultSet = getField("fResultSet");

        Receiver r = null;

        // statementmۂł΂AIprepareStatementĂяo܂B
        implementor.addLine("if (fStatement == null) {");
        implementor.addStatement("prepareStatement()");
        implementor.addLine("}");

        // resultSetԂł΁Acloses܂B
        Statement expression = new Statement(_resultSet);
        expression.join("!=", new Statement(Value.NULL));
        implementor.openIf(expression);
        implementor.addStatement(new Receiver(_resultSet, "close"));
        implementor.assign(_resultSet, new Statement(Value.NULL));
        implementor.closeIf();

        r = new Receiver(_statement);
        r.call("executeQuery");
        implementor.assign(_resultSet, r);
    }
}