/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.SQLException;

import blanco.db.definition.QueryIterator;
import blanco.db.exception.NoRowFoundException;
import blanco.db.exception.TooManyRowsFoundException;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;

/**
 * Singletruȅꍇɂ̂݁ÃNX͗p܂
 * 
 * @author Tosiki Iga
 */
public class GetSingleRowMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private Value _result = null;

    public GetSingleRowMethod(final BlancoDbObjectStorage storage,
            final Type rowObjectType, final QueryIterator iterator) {
        super("getSingleRow");
        this.storage = storage;

        _result = new Value(rowObjectType, "result");
    }

    public void setupSignature() {
        setReturnType(_result.getType());

        final Type noRowFoundException = new Type(storage.getSetting()
                .getRootNameSpace()
                + ".exception.NoRowFoundException");
        addException(noRowFoundException);
        addUsingType(noRowFoundException);
        final Type tooManyRowsFoundException = new Type(storage.getSetting()
                .getRootNameSpace()
                + ".exception.TooManyRowsFoundException");
        addException(tooManyRowsFoundException);
        addUsingType(tooManyRowsFoundException);

        addException(SQLException.class);

        getJavaDoc().addLine("݂̍s̃f[^IuWFNgƂĎ擾܂B<br>");
        getJavaDoc().addLine(
                "̃\bh𗘗pꍇɂ́Anext()Ȃǂ̃J[\𑀍삷郁\bhƂ͕pȂłB<br>");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("singleL<br>");
        getJavaDoc().addLine("ʂ1ȊȌꍇɂ́ANotSingleRowExceptionNX");
        getJavaDoc().addLine("hNX̗O܂B");
        getJavaDoc().addReturn("sIuWFNg");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        final Type exceptionType = storage
                .createRuntime(NoRowFoundException.class);

        implementor.openIf("next() == false");
        Call c = new Call(exceptionType);
        c.addArgument(new StringLiteral("sł܂łB"));
        implementor.addThrow(c);
        implementor.closeIf();

        implementor.emptyLine();

        implementor.addStatement(_result.getType().getName()
                + " result = getRow()");
        implementor.emptyLine();

        Type exeptionType = storage
                .createRuntime(TooManyRowsFoundException.class);

        // ꌏȏ̍XVǂ`FbNB
        implementor.openIf("next()");
        Call c2 = new Call(exeptionType);
        c2.addArgument(new StringLiteral("1ȏ̍s܂B"));
        implementor.addThrow(c2);
        implementor.closeIf();

        implementor.emptyLine();

        implementor.addReturn(_result);
    }
}