/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.anttask;

import java.io.File;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.MethodExpander;

/**
 * XMLt@C(^)Java\[XR[h܂B
 * 
 * XMLt@C͂JavaNXE\[XR[h܂B <br>
 * 
 * @author IGA Tosiki
 */
public class BlancoAntTaskXml2JavaClass {

    /**
     * XMLt@CJava\[XR[h𐶐܂B
     * 
     * @param fileSource
     *            XML^̓t@C
     * @param directoryTarget
     *            \[XR[ho̓fBNg
     */
    public void process(final File fileSource, final File directoryTarget) {
        final DOMResult result = BlancoXmlUtil.transformFile2Dom(fileSource);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                NodeList listCommon = elementSheet
                        .getElementsByTagName("blancoanttask-common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final Element elementCommon = (Element) listCommon.item(0);
                final String taskName = BlancoXmlUtil.getTextContent(
                        elementCommon, "taskName");
                if (taskName == null || taskName.trim().length() == 0) {
                    // ^XNꍇɂ̓XLbv܂B
                    continue;
                }

                expandSheet(elementSheet, directoryTarget);
            }
        }
    }

    /**
     * w̃V[g̋LqeWJ܂B
     * 
     * @param elementSheet
     *            ΏۂƂV[g
     * @param directoryTarget
     *            o͐fBNg
     */
    static void expandSheet(final Element elementSheet,
            final File directoryTarget) {
        final NodeList listCommon = elementSheet
                .getElementsByTagName("blancoanttask-common");
        final Element elementCommon = (Element) listCommon.item(0);
        final String taskName = BlancoXmlUtil.getTextContent(elementCommon,
                "taskName");
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");
        final String suffix = BlancoXmlUtil.getTextContent(elementCommon,
                "suffix");

        final NodeList listList = elementSheet
                .getElementsByTagName("blancoanttask-list");
        if (listList.getLength() == 0) {
            return;
        }

        final ClassExpander classExpander = new ClassExpander(new Type(
                packageName, "Abstract"
                        + BlancoNameAdjuster.toClassName(taskName)
                        + (suffix == null ? "" : suffix))) {
            protected boolean isAbstract() {
                return true;
            }

            protected void expandClassStruct() {
                addFileComment("Apache Ant^XN [" + taskName + "]̒ېeNX");
                getJavaDoc()
                        .addLine("Apache Ant^XN [" + taskName + "]̒ېeNXB");
                getJavaDoc().addLine("");
                if (description != null) {
                    getJavaDoc().addLine(
                            BlancoJavaSourceUtil
                                    .escapeStringAsJavaDoc(description)
                                    + "<br>");
                }
                getJavaDoc()
                        .addLine(
                                "̒ېeNXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B");
                getJavaDoc().addLine(
                        "̃NXpāApbP[W[" + packageName + "]"
                                + BlancoNameAdjuster.toClassName(taskName)
                                + (suffix == null ? "" : suffix)
                                + "NX쐬ĂBAnt^XN̏eLqĂB<br>");
                getJavaDoc().addLine("<br>");
                getJavaDoc().addLine("Ant^XNւ̑gݍݗ<br>");
                getJavaDoc().addLine("<pre>");
                getJavaDoc().addLine(
                        BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc("<taskdef name=\""
                                        + taskName.toLowerCase()
                                        + "\" classname=\""
                                        + packageName
                                        + "."
                                        + BlancoNameAdjuster
                                                .toClassName(taskName)
                                        + (suffix == null ? "" : suffix))
                                + "\">");
                getJavaDoc().addLine(
                        BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc("    <classpath>"));
                getJavaDoc()
                        .addLine(
                                BlancoJavaSourceUtil
                                        .escapeStringAsJavaDoc("        <fileset dir=\"lib\" includes=\"*.jar\" />"));
                getJavaDoc()
                        .addLine(
                                BlancoJavaSourceUtil
                                        .escapeStringAsJavaDoc("        <fileset dir=\"lib.ant\" includes=\"*.jar\" />"));
                getJavaDoc().addLine(
                        BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc("    </classpath>"));
                getJavaDoc().addLine(
                        BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc("</taskdef>"));
                getJavaDoc().addLine("</pre>");

                setSuperClass(new Type("org.apache.tools.ant.Task"));

                addImport(new Type("org.apache.tools.ant.BuildException"));

                final Element elementListRoot = (Element) listList.item(0);
                final NodeList listChildNodes = elementListRoot.getChildNodes();
                for (int index = 0; index < listChildNodes.getLength(); index++) {
                    final Element elementList = (Element) listChildNodes
                            .item(index);
                    final String no = BlancoXmlUtil.getTextContent(elementList,
                            "no");
                    final String attribute = BlancoXmlUtil.getTextContent(
                            elementList, "attribute");
                    final String isRequire = BlancoXmlUtil.getTextContent(
                            elementList, "isRequire");
                    final String attributeDefault = BlancoXmlUtil
                            .getTextContent(elementList, "default");
                    final String attributeDescription = BlancoXmlUtil
                            .getTextContent(elementList, "description");

                    if (attribute == null || attribute.trim().length() == 0) {
                        // attributew肳ĂȂꍇɂ͏܂B
                        continue;
                    }
                    if (isRequire != null && isRequire.trim().length() > 0) {
                        if (attributeDefault != null
                                && attributeDefault.trim().length() > 0) {
                            throw new IllegalArgumentException(
                                    "^XN["
                                            + taskName
                                            + "]AAgr[g["
                                            + attribute
                                            + "]ɂāA[K{][ftHg]Ɏw肳Ă܂B[K{][ftHg]͔rIɁAꂩ͎w肷Kv܂B");
                        }
                    }

                    final FieldExpander field1 = new FieldExpander(new Type(
                            "java.lang.String"), "f"
                            + BlancoNameAdjuster.toClassName(attribute));
                    field1.getJavaDoc().addLine(
                            "Ant^XN[" + attribute + "]Agr[g<br>");
                    if (no != null) {
                        field1.getJavaDoc().addLine("ڔԍ: " + no + "<br>");
                    }
                    if (attributeDescription != null) {
                        field1
                                .getJavaDoc()
                                .addLine(
                                        BlancoJavaSourceUtil
                                                .escapeStringAsJavaDoc(attributeDescription)
                                                + "<br>");
                    }
                    if (isRequire != null && isRequire.equals("true")) {
                        field1.getJavaDoc().addLine("K{<br>");
                    }
                    addField(field1);

                    addMethod(new MethodExpander("set"
                            + BlancoNameAdjuster.toClassName(attribute)) {
                        public void setupSignature() {
                            getJavaDoc().addLine(
                                    "Ant^XN[" + attribute
                                            + "]Agr[g̃Zb^[\bh<br>");
                            if (no != null) {
                                getJavaDoc().addLine("ڔԍ: " + no + "<br>");
                            }
                            if (attributeDescription != null) {
                                getJavaDoc()
                                        .addLine(
                                                BlancoJavaSourceUtil
                                                        .escapeStringAsJavaDoc(attributeDescription)
                                                        + "<br>");
                            }
                            getJavaDoc().addParameter("arg", "Zbgl");

                            addArgument(new Value(new Type("java.lang.String"),
                                    "arg"));
                        }

                        public void implement() {
                            getData().addLine(
                                    "f"
                                            + BlancoNameAdjuster
                                                    .toClassName(attribute)
                                            + " = arg;");
                        }
                    });

                    addMethod(new MethodExpander("get"
                            + BlancoNameAdjuster.toClassName(attribute)) {
                        public void setupSignature() {
                            getJavaDoc().addLine(
                                    "Ant^XN[" + attribute
                                            + "]Agr[g̃Zb^[\bh<br>");
                            if (no != null) {
                                getJavaDoc().addLine("ڔԍ: " + no + "<br>");
                            }
                            if (attributeDescription != null) {
                                getJavaDoc()
                                        .addLine(
                                                BlancoJavaSourceUtil
                                                        .escapeStringAsJavaDoc(attributeDescription)
                                                        + "<br>");
                            }
                            if (isRequire != null) {
                                getJavaDoc()
                                        .addLine(
                                                "K{Agr[głBApache Ant^XNŕKlw肳܂B<br>");
                            }
                            if (attributeDefault != null) {
                                getJavaDoc()
                                        .addLine(
                                                "ftHgl["
                                                        + BlancoJavaSourceUtil
                                                                .escapeStringAsJavaDoc(attributeDefault)
                                                        + "]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>");
                            }
                            getJavaDoc().addReturn("̃tB[h̒l");

                            setReturnType(new Type("java.lang.String"));
                        }

                        public void implement() {
                            getData().addLine(
                                    "return f"
                                            + BlancoNameAdjuster
                                                    .toClassName(attribute)
                                            + ";");
                        }
                    });
                }

                addAbstractMethod("protected abstract void process() throws IllegalArgumentException;");

                addMethod(new MethodExpander("execute") {
                    protected boolean isFinal() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "Ant^XÑCBApache Ant ̃\bhĂяo܂B");
                        getJavaDoc()
                                .addException(
                                        new Type(
                                                "org.apache.tools.ant.BuildException"),
                                        "^XNƂĂ̗OꍇB");

                        addException(new Type(
                                "org.apache.tools.ant.BuildException"));
                    }

                    public void implement() {
                        getData().addLine(
                                "System.out.println(\"" + taskName
                                        + "Task Jn\");");
                        getData().addLine("");

                        final Element elementListRoot = (Element) listList
                                .item(0);
                        final NodeList listChildNodes = elementListRoot
                                .getChildNodes();
                        for (int index = 0; index < listChildNodes.getLength(); index++) {
                            final Element elementList = (Element) listChildNodes
                                    .item(index);
                            final String isRequire = BlancoXmlUtil
                                    .getTextContent(elementList, "isRequire");
                            if (isRequire == null
                                    || isRequire.equals("true") == false) {
                                continue;
                            }

                            final String no = BlancoXmlUtil.getTextContent(
                                    elementList, "no");
                            final String attribute = BlancoXmlUtil
                                    .getTextContent(elementList, "attribute");

                            getData().addLine(
                                    "// "
                                            + (no == null ? "" : "ڔԍ[" + no
                                                    + "]A") + "Agr[g["
                                            + attribute
                                            + "]͕K{͂łB̓`FbNs܂B");
                            getData().addLine(
                                    "if (get"
                                            + BlancoNameAdjuster
                                                    .toClassName(attribute)
                                            + "() == null) {");
                            getData().addLine(
                                    "throw new BuildException(\"Agr[g["
                                            + attribute
                                            + "]ݒ肳Ă܂B𒆒f܂B\");");
                            getData().addLine("}");
                        }
                        for (int index = 0; index < listChildNodes.getLength(); index++) {
                            final Element elementList = (Element) listChildNodes
                                    .item(index);
                            final String attributeDefault = BlancoXmlUtil
                                    .getTextContent(elementList, "default");
                            if (attributeDefault == null) {
                                continue;
                            }

                            final String no = BlancoXmlUtil.getTextContent(
                                    elementList, "no");
                            final String attribute = BlancoXmlUtil
                                    .getTextContent(elementList, "attribute");

                            getData()
                                    .addLine(
                                            "// "
                                                    + (no == null ? ""
                                                            : "ڔԍ[" + no
                                                                    + "]A")
                                                    + "Agr[g["
                                                    + attribute
                                                    + "]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B");
                            getData().addLine(
                                    "if (get"
                                            + BlancoNameAdjuster
                                                    .toClassName(attribute)
                                            + "() == null) {");
                            getData()
                                    .addLine(
                                            "set"
                                                    + BlancoNameAdjuster
                                                            .toClassName(attribute)
                                                    + "(\"" + attributeDefault
                                                    + "\");");
                            getData().addLine("}");
                        }

                        getData().addLine("try {");
                        getData().addLine("// ۂAnt^XN̎又s܂B");
                        getData().addLine("process();");
                        getData().addLine(
                                "} catch (IllegalArgumentException e) {");
                        getData().addLine(
                                "throw new BuildException(e.getMessage());");
                        getData().addLine("} catch (Exception e) {");
                        getData().addLine("e.printStackTrace();");
                        getData()
                                .addLine(
                                        "throw new BuildException(\"^XNɗO܂B𒆒f܂B\" + e.toString());");
                        getData().addLine("} catch (Error e) {");
                        getData().addLine("e.printStackTrace();");
                        getData()
                                .addLine(
                                        "throw new BuildException(\"^XNɃG[܂B𒆒f܂B\" + e.toString());");
                        getData().addLine("}");
                    }
                });
            }
        };

        directoryTarget.mkdirs();
        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}