/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

package blanco.anttask.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.anttask.BlancoAntTaskMeta2Xml;
import blanco.anttask.BlancoAntTaskXml2JavaClass;

/**
 * BlancoAntTaskꎩĝ߂Ant^XNłB
 * 
 * @author IGA Tosiki
 */
public class BlancoAntTaskTask extends AbstractBlancoAntTaskTask {
    /**
     * AntTask̏s܂B
     * 
     * ̃\bh ېeNXłAbstractBlancoAntTaskTaskNXĂяo܂B
     * 
     * @throws IllegalArgumentException
     *             e͒lȌꍇɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        try {
            final File blancoTmpAntTaskDirectory = new File(getTmpdir()
                    + "/anttask");
            blancoTmpAntTaskDirectory.mkdirs();

            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            final File[] fileMeta = fileMetadir.listFiles();
            for (int index = 0; index < fileMeta.length; index++) {
                if (fileMeta[index].getName().endsWith(".xls") == false) {
                    continue;
                }
                final File fileTmpTarget = new File(blancoTmpAntTaskDirectory
                        + "/" + fileMeta[index].getName() + ".xml");

                InputStream inStream = null;
                OutputStream outStream = null;
                try {
                    inStream = new BufferedInputStream(new FileInputStream(
                            fileMeta[index]));
                    outStream = new BufferedOutputStream(new FileOutputStream(
                            fileTmpTarget));
                    new BlancoAntTaskMeta2Xml().process(inStream, outStream);
                    outStream.flush();
                } finally {
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (outStream != null) {
                        outStream.close();
                    }
                }
            }

            final File[] fileTmp = blancoTmpAntTaskDirectory.listFiles();
            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".xml")) {
                    new BlancoAntTaskXml2JavaClass().process(fileTmp[index],
                            new File(getTargetdir()));
                }
            }
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}
