/*
 * blancoCommons Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.calc.parser;

import jxl.Sheet;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import blanco.commons.calc.BlancoCalcUtil;

/**
 * CalcǂݎĂ݂邽߂̒ȒPSAX2p[TłB <br>
 * ɂ߂ĒPSAXp[XƂẴTvłB
 * 
 * @author Tosiki Iga
 */
public class BlancoSimpleCalcParser extends AbstractBlancoCalcParser {

    protected void startSheet(String sheetName) throws SAXException {
        System.out.println("V[g[" + sheetName + "]...");
        AttributesImpl attrImpl = new AttributesImpl();
        attrImpl.addAttribute("", "name", "name", "CDATA", sheetName);
        getContentHandler().startElement("", "sheet", "sheet", attrImpl);
    }

    protected void endSheet(Sheet sheet) throws SAXException {
        getContentHandler().endElement("", "sheet", "sheet");
    }

    protected void startRow(int row) throws SAXException {
    }

    protected void endRow(int row) throws SAXException {
    }

    protected void startColumn(int column) throws SAXException {
    }

    protected void endColumn(int column) throws SAXException {
    }

    /**
     * Zp[XꂽۂɌĂяo܂B
     * 
     * @param column
     *            ł1IWŌĂяo܂B
     * @param row
     *            ł1IWŌĂяo܂B
     * @param value
     * @throws SAXException
     */
    protected void fireCell(int column, int row, String cellValue)
            throws SAXException {
        if (cellValue.length() == 0) {
            return;
        }

        StringBuffer strResult = new StringBuffer(256);
        strResult.append("  (");
        strResult.append(BlancoCalcUtil.columnToLabel(column));
        strResult.append(row);
        strResult.append(")  ");
        strResult.append(cellValue);
        System.out.println(strResult.toString());

        AttributesImpl attrImpl = new AttributesImpl();
        attrImpl.addAttribute("", "position", "position", "CDATA",
                BlancoCalcUtil.columnToLabel(column) + row);
        getContentHandler().startElement("", "cell", "cell", attrImpl);
        char[] charArray = cellValue.toCharArray();
        getContentHandler().characters(charArray, 0, charArray.length);
        getContentHandler().endElement("", "cell", "cell");
    }
}
