/*
 * blancoDb
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.SQLException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.definition.QueryField;
import blanco.db.definition.QueryIterator;
import blanco.db.mapping.BlancoDbMappingUtil;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class UpdateObjectMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private Value _resultSet = null;

    private QueryField _field = null;

    public UpdateObjectMethod(final BlancoDbObjectStorage storage,
            final QueryIterator iterator, final QueryField field) {
        super("update" + BlancoNameAdjuster.toClassName(field.getName()));
        _field = field;
        this.storage = storage;
    }

    public void setupSignature() {
        addException(SQLException.class);

        final Value value = new Value(_field.getJavaType(), BlancoNameAdjuster
                .toParameterName(_field.getName()));
        addArgument(value);

        if (_field.getTypeName().equals("InputStream")
                || _field.getTypeName().equals("Reader")) {
            addArgument(new Value(int.class, "sourceLength"));
        }

        getJavaDoc().addLine("'" + _field.getName() + "'XV܂B<br>");
        getJavaDoc().addParameter(
                BlancoNameAdjuster.toParameterName(_field.getName()),
                _field.getName() + "ɃZbgl");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + ": "
                    + BlancoNameAdjuster.toParameterName(_field.getName())
                    + " = \" + "
                    + BlancoNameAdjuster.toParameterName(_field.getName())
                    + ");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        _resultSet = getField("fResultSet");

        Receiver r = null;
        Call c = null;
        r = new Receiver(_resultSet);

        if (_field.getObjectMappingForPrimitiveNullSupport()) {
            implementor.openIf(BlancoNameAdjuster.toParameterName(_field
                    .getName())
                    + " == null");
            implementor.addStatement("fResultSet.updateNull("
                    + new StringLiteral(_field.getName()) + ")");
            implementor.addElse();
        }

        c = r.call(BlancoDbMappingUtil.getResultSetUpdateMethodName(_field
                .getTypeName()));

        c.addArgument(new StringLiteral(_field.getJdbcName()));

        c.addArgument(BlancoDbMappingUtil.mapWrapperClassIntoPrimitive(
                BlancoNameAdjuster.toParameterName(_field.getName()), _field
                        .getTypeName()));

        if (_field.getTypeName().equals("Date")) {
            // BlancoDbMappingUtil.mapWrapperClassIntoPrimitive\bhTimestamp^KvłB
            c.addUsingType(new Type("java.sql.Timestamp"));
        }

        if (_field.getTypeName().equals("InputStream")
                || _field.getTypeName().equals("Reader")) {
            c.addArgument(new Value(int.class, "sourceLength"));
        }

        implementor.addStatement(r);

        if (_field.getObjectMappingForPrimitiveNullSupport()) {
            implementor.closeIf();
        }
    }
}