/*
 * blancoResourceBundle Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.resourcebundle.expand;

import java.io.File;
import java.math.BigDecimal;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.Constructor;
import blanco.ig.expander.method.MethodExpander;
import blanco.resourcebundle.BlancoResourceBundleConstants;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * blancoResourceBundle <br>
 * ^񂩂vpeBt@C⃊\[XohANZTJava\[XR[h <br>
 * 
 * XMLDOMGg͂Ƃăt@Co͂܂B <br>
 * IɗpNXłB <br>
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleExpandResourceBundle {
    private final BlancoResourceBundleResourceBundle bundle = new BlancoResourceBundleResourceBundle();

    public void expand(final Element elementSheet, final Element elementCommon,
            final File directoryTarget) {
        final String baseName = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.BASE_NAME);
        final String suffix = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.SUFFIX);
        final String className = baseName + (suffix == null ? "" : suffix);
        // System.out.println("NX:" + className);
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.PACKAGE_NAME);
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.DESCRIPTION);
        final ArrayList listKnownLocale = new ArrayList();
        final HashMap mapBundle = new HashMap();
        // ^ꂽpbP[Ŵ܂ܗp܂B
        ClassExpander classExpander = new ClassExpander(new Type(packageName,
                className)) {

            protected void expandClassStruct() {
                addFileComment(bundle.getExpandresourceSrc001());
                getJavaDoc().addLine(
                        bundle
                                .getExpandresourceSrc011(baseName
                                        + (description == null ? "" : "/"
                                                + description)));
                getJavaDoc().addLine(bundle.getExpandresourceSrc012());

                {
                    NodeList listCommonList = elementSheet
                            .getElementsByTagName("blancoresourcebundle-common");
                    if (listCommonList.getLength() == 0) {
                        // commonꍇɂ̓XLbv܂B
                        return;
                    }
                    NodeList listLocale = ((Element) listCommonList.item(0))
                            .getElementsByTagName("locale");
                    final int sizeListLocale = listLocale.getLength();
                    if (sizeListLocale > 0) {
                        getJavaDoc().addLine(bundle.getExpandresourceSrc013());
                        getJavaDoc().addLine("<UL>");
                        final HashMap mapExistLocale = new HashMap();
                        for (int indexLocale = 0; indexLocale < sizeListLocale; indexLocale++) {
                            final Element elementLocale = (Element) listLocale
                                    .item(indexLocale);
                            final String locale = BlancoXmlUtil
                                    .getTextContent(elementLocale);
                            if (mapExistLocale.get(locale) != null) {
                                throw new IllegalArgumentException(bundle
                                        .getExpandresourceErr001(baseName
                                                + (description == null ? ""
                                                        : "/" + description),
                                                locale));
                            }
                            listKnownLocale.add(locale);
                            mapExistLocale.put(locale, locale);
                            getJavaDoc().addLine("<LI>" + locale);
                        }
                        getJavaDoc().addLine("</UL>");
                    }
                }

                final FieldExpander field1 = new FieldExpander(new Type(
                        "java.util.ResourceBundle"), "fResourceBundle");
                field1.getJavaDoc().addLine(bundle.getExpandresourceSrc014());
                field1.getJavaDoc().addLine(bundle.getExpandresourceSrc015());
                addField(field1);

                addMethod(new Constructor(className) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc021(className));
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc022(baseName));
                    }

                    public void implement() {
                        // ɃC|[gKvłB
                        addUsingType(new Type(
                                "java.util.MissingResourceException"));

                        getData().addLine("try {");
                        getData().addLine(
                                "fResourceBundle = ResourceBundle.getBundle(\""
                                        + baseName + "\");");
                        getData().addLine(
                                "} catch (MissingResourceException ex) {");
                        getData()
                                .addLine(
                                        "final String message = \""
                                                + bundle
                                                        .getExpandresourceSrc023(baseName)
                                                + "\" + ex.toString();");
                        getData().addLine("System.out.println(message);");
                        getData().addLine("}");
                    }
                });

                addMethod(new Constructor(className) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc031(className));
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc032(baseName));
                        getJavaDoc().addParameter("locale",
                                bundle.getExpandresourceSrc033());
                        addArgument(new Value(new Type("java.util.Locale"),
                                "locale"));
                    }

                    public void implement() {
                        getData().addLine("try {");
                        getData().addLine(
                                "fResourceBundle = ResourceBundle.getBundle(\""
                                        + baseName + "\", locale);");
                        getData().addLine(
                                "} catch (MissingResourceException ex) {");
                        getData()
                                .addLine(
                                        "final String message = \""
                                                + bundle
                                                        .getExpandresourceSrc034(baseName)
                                                + "\" + ex.toString();");
                        getData().addLine("System.out.println(message);");
                        getData().addLine("}");
                    }
                });

                addMethod(new Constructor(className) {
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc041(className));
                        getJavaDoc().addLine(
                                bundle.getExpandresourceSrc042(baseName));
                        getJavaDoc().addParameter("locale",
                                bundle.getExpandresourceSrc043());
                        getJavaDoc().addParameter("loader",
                                bundle.getExpandresourceSrc044());
                        addArgument(new Value(new Type("java.util.Locale"),
                                "locale"));
                        addArgument(new Value(
                                new Type("java.lang.ClassLoader"), "loader"));
                    }

                    public void implement() {
                        getData().addLine("try {");
                        getData().addLine(
                                "fResourceBundle = ResourceBundle.getBundle(\""
                                        + baseName + "\", locale, loader);");
                        getData().addLine(
                                "} catch (MissingResourceException ex) {");
                        getData()
                                .addLine(
                                        "final String message = \""
                                                + bundle
                                                        .getExpandresourceSrc045(baseName)
                                                + "\" + ex.toString();");
                        getData().addLine("System.out.println(message);");
                        getData().addLine("}");
                    }
                });

                NodeList listResourceList = elementSheet
                        .getElementsByTagName("blancoresourcebundle-resourceList");
                if (listResourceList.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    return;
                }

                NodeList listResource = ((Element) listResourceList.item(0))
                        .getElementsByTagName("resource");
                final int sizeListResource = listResource.getLength();
                for (int indexResource = 0; indexResource < sizeListResource; indexResource++) {
                    final Element elementResource = (Element) listResource
                            .item(indexResource);

                    final String fieldResourceId = BlancoXmlUtil
                            .getTextContent(elementResource,
                                    BlancoResourceBundleConstants.RESOURCE_KEY);
                    addMethod(new MethodExpander("get"
                            + BlancoNameAdjuster.toClassName(fieldResourceId)) {
                        public void setupSignature() {
                            final NodeList nodeListResourceString = elementResource
                                    .getElementsByTagName(BlancoResourceBundleConstants.RESOURCE_STRING);
                            getJavaDoc().addLine(
                                    "bundle[" + baseName + "], key["
                                            + fieldResourceId + "]<br>");
                            getJavaDoc().addLine("<br>");
                            final HashMap mapProcessedLocale = new HashMap();
                            Format[] previousFormatList = null;
                            for (int indexResourceString = 0; indexResourceString < nodeListResourceString
                                    .getLength(); indexResourceString++) {
                                if (nodeListResourceString
                                        .item(indexResourceString) instanceof Element) {
                                    final Element elementResourceString = (Element) nodeListResourceString
                                            .item(indexResourceString);
                                    String resourceString = BlancoXmlUtil
                                            .getTextContent(elementResourceString);
                                    final String locale = elementResourceString
                                            .getAttribute("locale");
                                    if (resourceString == null) {
                                        // null̂܂܂ƍ̂ŋ󕶎Zbg܂B
                                        resourceString = "";
                                    }
                                    getJavaDoc()
                                            .addLine(
                                                    "["
                                                            + BlancoJavaSourceUtil
                                                                    .escapeStringAsJavaDoc(resourceString)
                                                            + "] (" + locale
                                                            + ")<br>");
                                    if (mapProcessedLocale.get(locale) != null) {
                                        // }bvɋLO ɏς݂̃P[łȂǂ`FbN܂B
                                        throw new IllegalArgumentException(
                                                bundle
                                                        .getExpandresourceErr002(
                                                                baseName
                                                                        + (description == null ? ""
                                                                                : "/"
                                                                                        + description),
                                                                locale,
                                                                fieldResourceId));
                                    }
                                    // ς݂̃P[ł邱ƂL܂B
                                    mapProcessedLocale.put(locale, locale);
                                    if (mapBundle.get(fieldResourceId) == null) {
                                        mapBundle.put(fieldResourceId,
                                                resourceString);
                                    }
                                    Format[] formatList = null;
                                    try {
                                        formatList = new MessageFormat(
                                                resourceString)
                                                .getFormatsByArgumentIndex();
                                    } catch (IllegalArgumentException ex) {
                                        throw new IllegalArgumentException(
                                                bundle
                                                        .getExpandresourceErr003(
                                                                baseName,
                                                                elementResourceString
                                                                        .getAttribute("locale"),
                                                                fieldResourceId,
                                                                BlancoJavaSourceUtil
                                                                        .escapeStringAsJavaSource(resourceString))
                                                        + ex.toString());
                                    }

                                    for (int indexFormat = 0; indexFormat < formatList.length; indexFormat++) {
                                        String strArgType = "java.lang.String";
                                        if (formatList[indexFormat] == null) {
                                            // tH[}bgȂ:
                                            // java.lang.Stringւ̃}bvÓ
                                            strArgType = "java.lang.String";
                                        } else if (formatList[indexFormat] instanceof java.text.NumberFormat) {
                                            // java.math.BigDecimalւ̃}bvÓ
                                            strArgType = "java.math.BigDecimal";
                                        } else if (formatList[indexFormat] instanceof java.text.DateFormat) {
                                            // java.util.Dateւ̃}bvÓ
                                            strArgType = "java.util.Date";
                                        } else if (formatList[indexFormat] instanceof java.text.ChoiceFormat) {
                                            // intւ̃}bvÓ
                                            strArgType = "int";
                                        } else {
                                            strArgType = "java.lang.String";
                                        }
                                        if (indexResourceString == 0) {
                                            // ̂݃\bh𐶐
                                            getJavaDoc()
                                                    .addParameter(
                                                            "arg" + indexFormat,
                                                            bundle
                                                                    .getExpandresourceSrc101(
                                                                            toBigDecimal(indexFormat),
                                                                            strArgType));
                                            addArgument(new Value(new Type(
                                                    strArgType), "arg"
                                                    + indexFormat));
                                        }
                                    }
                                    getJavaDoc()
                                            .addReturn(
                                                    bundle
                                                            .getExpandresourceSrc102(fieldResourceId));

                                    if (indexResourceString == 0) {
                                        // ͔rs܂B
                                    } else {
                                        if (previousFormatList == null
                                                && formatList == null) {
                                            // vĂ܂B肠܂B
                                        } else if (previousFormatList == null
                                                && formatList != null) {
                                            throw new IllegalArgumentException(
                                                    bundle
                                                            .getExpandresourceErr004(
                                                                    baseName
                                                                            + (description == null ? ""
                                                                                    : "/"
                                                                                            + description),
                                                                    locale,
                                                                    fieldResourceId,
                                                                    toBigDecimal(formatList.length)));
                                        } else if (previousFormatList != null
                                                && formatList == null) {
                                            throw new IllegalArgumentException(
                                                    bundle
                                                            .getExpandresourceErr005(
                                                                    baseName
                                                                            + (description == null ? ""
                                                                                    : "/"
                                                                                            + description),
                                                                    locale,
                                                                    fieldResourceId,
                                                                    toBigDecimal(previousFormatList.length)));
                                        } else {
                                            if (previousFormatList.length != formatList.length) {
                                                throw new IllegalArgumentException(
                                                        bundle
                                                                .getExpandresourceErr006(
                                                                        baseName
                                                                                + (description == null ? ""
                                                                                        : "/"
                                                                                                + description),
                                                                        locale,
                                                                        fieldResourceId,
                                                                        toBigDecimal(formatList.length),
                                                                        toBigDecimal(previousFormatList.length)));
                                            }
                                            for (int indexFormat = 0; indexFormat < formatList.length; indexFormat++) {
                                                final String previousFormatClass = (previousFormatList[indexFormat] == null ? bundle
                                                        .getExpandresourceSrc051()
                                                        : previousFormatList[indexFormat]
                                                                .getClass()
                                                                .getName());
                                                final String formatClass = (formatList[indexFormat] == null ? bundle
                                                        .getExpandresourceSrc051()
                                                        : formatList[indexFormat]
                                                                .getClass()
                                                                .getName());
                                                if (formatClass
                                                        .equals(previousFormatClass) == false) {
                                                    throw new IllegalArgumentException(
                                                            bundle
                                                                    .getExpandresourceErr007(
                                                                            baseName
                                                                                    + (description == null ? ""
                                                                                            : "/"
                                                                                                    + description),
                                                                            locale,
                                                                            fieldResourceId,
                                                                            formatClass,
                                                                            previousFormatClass));
                                                }
                                            }
                                        }
                                    }
                                    // ÕXgƂċL܂B
                                    // null낤낤L_|CgłB
                                    previousFormatList = formatList;
                                }
                            }

                            // P[SđĂ邩ǂ̃`FbNs܂B
                            for (int indexCheck = 0; indexCheck < listKnownLocale
                                    .size(); indexCheck++) {
                                final String localeCheck = (String) listKnownLocale
                                        .get(indexCheck);
                                Object objCheck = mapProcessedLocale
                                        .get(localeCheck);
                                if (objCheck == null) {
                                    getJavaDoc()
                                            .addLine(
                                                    bundle
                                                            .getExpandresourceSrc103(localeCheck));
                                }
                            }

                            setReturnType(new Type("java.lang.String"));
                        }

                        public void implement() {
                            final String resourceString = (String) mapBundle
                                    .get(fieldResourceId);

                            getData().addLine(
                                    "// " + bundle.getExpandresourceSrc104());
                            getData()
                                    .addLine(
                                            "String strFormat = \""
                                                    + BlancoJavaSourceUtil
                                                            .escapeStringAsJavaSource(resourceString)
                                                    + "\";");
                            getData().addLine("try {");
                            getData().addLine("if (fResourceBundle != null) {");
                            getData()
                                    .addLine(
                                            "strFormat = fResourceBundle.getString(\""
                                                    + BlancoJavaSourceUtil
                                                            .escapeStringAsJavaSource(fieldResourceId)
                                                    + "\");");
                            getData().addLine("}");
                            getData().addLine(
                                    "} catch (MissingResourceException ex) {");
                            getData().addLine(
                                    "final String message = \""
                                            + bundle.getExpandresourceSrc105(
                                                    baseName, fieldResourceId)
                                            + "\" + ex.toString();");
                            getData().addLine("System.out.println(message);");
                            getData().addLine("}");

                            MessageFormat messageFormat = new MessageFormat(
                                    resourceString);
                            Format[] formatList = messageFormat
                                    .getFormatsByArgumentIndex();
                            if (formatList.length > 0) {
                                String strArgForFormat = "";
                                for (int index = 0; index < formatList.length; index++) {
                                    if (index != 0) {
                                        strArgForFormat += ", ";
                                    }
                                    strArgForFormat += ("arg" + index);
                                }

                                addUsingType(new Type("java.text.MessageFormat"));
                                getData()
                                        .addLine(
                                                "final MessageFormat messageFormat = new MessageFormat(strFormat);");
                                getData()
                                        .addLine(
                                                "final StringBuffer strbuf = new StringBuffer();");
                                getData()
                                        .addLine(
                                                "// "
                                                        + bundle
                                                                .getExpandresourceSrc106());
                                getData().addLine(
                                        "messageFormat.format(new Object[] {"
                                                + strArgForFormat
                                                + "}, strbuf, null);");

                                getData().addLine("return strbuf.toString();");
                            } else {
                                getData()
                                        .addLine(
                                                "// "
                                                        + bundle
                                                                .getExpandresourceSrc107());
                                getData().addLine("return strFormat;");
                            }
                        }
                    });

                }
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }

    /**
     * intBigDecimalɕϊ܂B<br>
     * BigDecimal̃RXgN^Ől͂̂1.5ȍ~ɓĂ܂B<br>
     * ̃\bh́ÃRXgN^ėpȂ߂̃\bhłB
     * 
     * @param value
     * @return
     */
    private static final BigDecimal toBigDecimal(final int value) {
        return new BigDecimal(String.valueOf(value));
    }
}