/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Yasuo Nakanishi
 */
public class SourceFinder {
    private List _sourceDirectories = new ArrayList();

    public SourceFinder() {

    }

    public void addSourceDirectory(String path) {
        _sourceDirectories.add(path);
    }

    private String toPath(Class targetClass) {
        return targetClass.getName().replaceAll("\\.", "/") + ".java";
    }

    private String findFileSystem(String sourcePath) {
        String result = null;
        String path = "";
        String sourceDirectory = "";
        for (int i = 0; i < _sourceDirectories.size(); i++) {
            sourceDirectory = (String) _sourceDirectories.get(i);
            path = sourceDirectory + "/" + sourcePath;
            if (new File(path).exists()) {
                result = path;
            }
        }
        if (result == null) {
            throwException(sourcePath);
        }
        return result;
    }

    private void throwException(String sourcePath) {
        String message = "\[X܂łBPath:" + sourcePath;
        throw new RuntimeException(message);
    }

    private String findFromClassPath(Class targetClass, String sourcePath) {
        String result = "";
        if (targetClass.getClassLoader().getResource(sourcePath) != null) {
            result = sourcePath;
        } else {
            throwException(sourcePath);
        }
        return result;
    }

    public String getSourcePath(Class targetClass) {
        String result = null;
        String sourcePath = toPath(targetClass);

        try {
            result = findFileSystem(sourcePath);
        } catch (RuntimeException e) {
            result = findFromClassPath(targetClass, sourcePath);
        }
        return result;
    }

    public String getResourcePath(Class targetClass) {
        return toPath(targetClass);
    }
}
