/*
 * blanco Framework Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */

package blanco.opendocument;

/**
 * OpenDocument߂̃[eBeBNXQ
 * 
 * OpenDocumentɊւ郆[eBeB\bhW߂NXłB
 * 
 * @author IGA Tosiki
 */
public class BlancoOpenDocumentUtil {
    /**
     * ^ꂽOpenDocument̃hLgRecAuL[𗊂Ɂusv𒊏o܂B<br>
     * ̂悤ȒuL[܂ށusvȂꍇɂnull߂܂B<br>
     * OƂāAXML̑S̃C[Wꊇŗ^A`ĂȂPš^ɂȂĂ邱ƂłB<br>
     * OpenOffice.org 2.0.0 ł ̂悤ɂȂĂ܂B<br>
     * ܂AŎw\Ȃ̂́uvĂ܂B
     * 
     * @param sourceDocumentContent
     *            ΏۂƂXML̃C[W
     * @param findReplaceKey
     *            uL[ƂČɗp镶Bߒɂāu#L[vŌs܂AŎw肷̂ #
     *            łB
     * @return usv̕Butable:table-rowṽc[ꎮԂ܂B̂悤ȒuL[Ȃꍇɂnull߂܂B
     */
    public static final String getTableRowFromContent(
            final String sourceDocumentContent, final String findReplaceKey) {
        final int pointKey = sourceDocumentContent.indexOf(">#"
                + findReplaceKey + "<");
        if (pointKey < 0) {
            // L[Ȃ̂ŁA̍s͏܂Bnullǂ܂B
            return null;
        }

        // Op[g𒊏o܂B
        final String headPartOfXml = sourceDocumentContent.substring(0,
                pointKey);
        final int tableStart = headPartOfXml.lastIndexOf("<table:table-row");
        if (tableStart < 0) {
            throw new IllegalArgumentException("L[[" + findReplaceKey
                    + "]̂ɁAV[g̃e[uJn^Oł܂B");
        }

        // 㔼p[g𒊏o܂B
        final String tailPartOfXml = sourceDocumentContent.substring(pointKey);
        final int tableEnd = tailPartOfXml.indexOf("</table:table-row>");
        if (tableEnd < 0) {
            throw new IllegalArgumentException("L[[" + findReplaceKey
                    + "]̂ɁAV[g̃e[uI^Oł܂B");
        }

        // usv\Ã^O߂܂B
        return sourceDocumentContent.substring(tableStart, pointKey + tableEnd
                + "</table:table-row>".length());
    }
}
