/*
 * blanco Framework Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.report.task;

import java.io.File;

import blanco.uno.BlancoUnoConverter;

public class BlancoReportConvertCalcTask extends
        AbstractBlancoReportConvertCalcTask {

    protected void process() throws IllegalArgumentException {
        final File fileInput = new File(getInput());
        final File fileOutput = new File(getOutput());

        if (fileInput.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ̓t@C["
                    + fileInput.getAbsolutePath() + "]܂B");
        }
        if (fileInput.isFile() == false) {
            throw new IllegalArgumentException("w肳ꂽ̓t@C["
                    + fileInput.getAbsolutePath() + "]̓t@Cł͂܂B");
        }
        if (fileInput.canRead() == false) {
            throw new IllegalArgumentException("w肳ꂽ̓t@C["
                    + fileInput.getAbsolutePath() + "]͓ǂݍނƂł܂B");
        }
        if (fileOutput.exists() && fileOutput.canWrite() == false) {
            throw new IllegalArgumentException("w肳ꂽo̓t@C["
                    + fileOutput.getAbsolutePath() + "]͊ɑ݂A݂ł܂B");
        }

        new BlancoUnoConverter().convertAsCalc(fileInput, fileOutput);
    }
}
