/*
 * blancoResourceBundle Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.resourcebundle;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.SAXException;

import blanco.resourcebundle.concretesax.BlancoResourceBundleXmlHandler;
import blanco.resourcebundle.concretesax.BlancoResourceBundleXmlSerializer;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * blancoResourceBundle <br>
 * ^񂩂vpeBt@C⃊\[XohANZTJava\[XR[h <br>
 * 
 * XML̒`eW񂵂Ȃ܂<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleXml2CombinedXml {
    private final BlancoResourceBundleResourceBundle bundle = new BlancoResourceBundleResourceBundle();

    public void process(final File fileXmlSource,
            final File fileCombinedXmlTarget) throws IOException,
            TransformerException {
        SAXResult result = new SAXResult(new BlancoResourceBundleXmlHandler() {
            private BlancoResourceBundleCombineResourceBase resourceBase = null;

            private ArrayList resourceBaseList = new ArrayList();

            public void startDocument() throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void startElementWorkbook(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementWorkbook(String uri, String localName,
                    String qName) throws SAXException {
                // ̏ꏊCombinedXML𐶐܂B
                OutputStream outStream = null;
                try {
                    outStream = new BufferedOutputStream(new FileOutputStream(
                            fileCombinedXmlTarget));
                    final BlancoResourceBundleXmlSerializer serializer = new BlancoResourceBundleXmlSerializer(
                            outStream);
                    serializer.startDocument();
                    serializer.startElementWorkbook();
                    serializer.characters("\n");

                    for (int indexBase = 0; indexBase < resourceBaseList.size(); indexBase++) {
                        BlancoResourceBundleCombineResourceBase resourceBaseCurrent = (BlancoResourceBundleCombineResourceBase) resourceBaseList
                                .get(indexBase);
                        if (resourceBaseCurrent.getBaseName() == null) {
                            continue;
                        }
                        if (resourceBaseCurrent.getPackageName() == null) {
                            throw new SAXException(
                                    new IllegalArgumentException(
                                            bundle
                                                    .getXml2combinedxmlErr001(resourceBaseCurrent
                                                            .getBaseName())));
                        }
                        if (resourceBaseCurrent.getSuffix() == null) {
                            resourceBaseCurrent.setSuffix("");
                        }

                        serializer.characters("  ");
                        serializer.startElementSheet(resourceBaseCurrent
                                .getBaseName());
                        serializer.characters("\n");
                        serializer.characters("    ");
                        serializer.startElementBlancoresourcebundleCommon();
                        serializer.characters("\n");
                        serializer.characters("      ");
                        serializer.startElementBaseName();
                        serializer
                                .characters(resourceBaseCurrent.getBaseName());
                        serializer.endElementBaseName();
                        serializer.characters("\n");
                        serializer.characters("      ");
                        for (int index = 0; index < resourceBaseCurrent
                                .getListLocale().size(); index++) {
                            serializer.startElementLocale();
                            serializer.characters((String) resourceBaseCurrent
                                    .getListLocale().get(index));
                            serializer.endElementLocale();
                        }
                        serializer.characters("\n");
                        serializer.characters("      ");
                        serializer.startElementPackageName();
                        serializer.characters(resourceBaseCurrent
                                .getPackageName());
                        serializer.endElementPackageName();
                        serializer.characters("\n");
                        serializer.characters("      ");
                        serializer.startElementSuffix();
                        serializer.characters(resourceBaseCurrent.getSuffix());
                        serializer.endElementSuffix();
                        serializer.characters("\n");
                        serializer.characters("    ");
                        serializer.endElementBlancoresourcebundleCommon();
                        serializer.characters("\n");
                        serializer.characters("    ");
                        serializer
                                .startElementBlancoresourcebundleResourceList();
                        serializer.characters("\n");
                        for (int index = 0; index < resourceBaseCurrent
                                .getListResouce().size(); index++) {
                            BlancoResourceBundleCombineResourceItem resourceItem = (BlancoResourceBundleCombineResourceItem) resourceBaseCurrent
                                    .getListResouce().get(index);
                            if (resourceItem == null
                                    || resourceItem.getResourceKey() == null) {
                                // L[Ȃꍇɂ̓XLbv܂B
                                continue;
                            }

                            serializer.characters("      ");
                            serializer.startElementResource();
                            serializer.characters("\n");
                            if (resourceItem.getNo() != null) {
                                serializer.characters("        ");
                                serializer.startElementNo();
                                serializer.characters(resourceItem.getNo());
                                serializer.endElementNo();
                                serializer.characters("\n");
                            }
                            serializer.characters("        ");
                            serializer.startElementResourceKey();
                            serializer
                                    .characters(resourceItem.getResourceKey());
                            serializer.endElementResourceKey();
                            serializer.characters("\n");
                            for (int indexLocale = 0; indexLocale < resourceItem
                                    .getResourceList().size(); indexLocale++) {
                                BlancoResourceBundleCombineResourceMessageItem messageStructure = (BlancoResourceBundleCombineResourceMessageItem) resourceItem
                                        .getResourceList().get(indexLocale);
                                serializer.characters("        ");
                                serializer
                                        .startElementResourceString(messageStructure
                                                .getKey());
                                serializer.characters(messageStructure
                                        .getMessage());
                                serializer.endElementResourceString();
                                serializer.characters("\n");
                            }
                            serializer.characters("      ");
                            serializer.endElementResource();
                            serializer.characters("\n");
                        }
                        serializer.characters("    ");
                        serializer.endElementBlancoresourcebundleResourceList();
                        serializer.characters("\n");
                        serializer.characters("  ");
                        serializer.endElementSheet();
                        serializer.characters("\n");
                    }

                    serializer.endElementWorkbook();
                    serializer.endDocument();
                    outStream.flush();
                } catch (IOException e) {
                    e.printStackTrace();
                    new SAXException(e);
                } catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                    new SAXException(e);
                } finally {
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                        new SAXException(e);
                    }
                }
            }

            public void charactersWorkbook(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceWorkbook(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementSheet(String uri, String localName,
                    String qName, String attrName) throws SAXException {
            }

            public void endElementSheet(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersSheet(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceSheet(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementBlancoresourcebundleCommon(String uri,
                    String localName, String qName) throws SAXException {
            }

            public void endElementBlancoresourcebundleCommon(String uri,
                    String localName, String qName) throws SAXException {
            }

            public void charactersBlancoresourcebundleCommon(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void ignorableWhitespaceBlancoresourcebundleCommon(
                    char[] ch, int start, int length) throws SAXException {
            }

            public void startElementBaseName(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementBaseName(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersBaseName(char[] ch, int start, int length)
                    throws SAXException {
                BlancoResourceBundleCombineResourceBase resourceBaseFound = null;
                for (int index = 0; index < resourceBaseList.size(); index++) {
                    final BlancoResourceBundleCombineResourceBase resourceBaseLook = (BlancoResourceBundleCombineResourceBase) resourceBaseList
                            .get(index);
                    if (resourceBaseLook.getBaseName().equals(
                            new String(ch, start, length))) {
                        resourceBaseFound = resourceBaseLook;
                        break;
                    }
                }
                if (resourceBaseFound == null) {
                    resourceBase = new BlancoResourceBundleCombineResourceBase();
                    resourceBase.setBaseName(new String(ch, start, length));
                    resourceBaseList.add(resourceBase);
                }
            }

            public void ignorableWhitespaceBaseName(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementLocale(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementLocale(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersLocale(char[] ch, int start, int length)
                    throws SAXException {
                try {
                    if (resourceBase != null) {
                        resourceBase.getListLocale().add(
                                new String(ch, start, length));
                        resourceBase.setCurrentLocale(new String(ch, start,
                                length));
                    }
                } catch (Exception ex) {
                    throw new SAXException(ex);
                }
            }

            public void ignorableWhitespaceLocale(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementPackageName(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementPackageName(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersPackageName(char[] ch, int start, int length)
                    throws SAXException {
                if (resourceBase != null) {
                    if (resourceBase.getPackageName() != null
                            && resourceBase.getPackageName().equals(
                                    new String(ch, start, length)) == false) {
                        throw new SAXException(new IllegalArgumentException(
                                bundle.getXml2combinedxmlErr002(resourceBase
                                        .getBaseName(), resourceBase
                                        .getPackageName(), new String(ch,
                                        start, length))));
                    }
                    resourceBase.setPackageName(new String(ch, start, length));
                }
            }

            public void ignorableWhitespacePackageName(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementSuffix(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementSuffix(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersSuffix(char[] ch, int start, int length)
                    throws SAXException {
                if (resourceBase != null) {
                    if (resourceBase.getSuffix() != null
                            && resourceBase.getSuffix().equals(
                                    new String(ch, start, length)) == false) {
                        throw new SAXException(new IllegalArgumentException(
                                bundle.getXml2combinedxmlErr003(resourceBase
                                        .getSuffix(), new String(ch, start,
                                        length))));
                    }
                    resourceBase.setSuffix(new String(ch, start, length));
                }
            }

            public void ignorableWhitespaceSuffix(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementBlancoresourcebundleResourceList(
                    String uri, String localName, String qName)
                    throws SAXException {
            }

            public void endElementBlancoresourcebundleResourceList(String uri,
                    String localName, String qName) throws SAXException {
            }

            public void charactersBlancoresourcebundleResourceList(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void ignorableWhitespaceBlancoresourcebundleResourceList(
                    char[] ch, int start, int length) throws SAXException {
            }

            public void startElementResource(String uri, String localName,
                    String qName) throws SAXException {
                if (resourceBase != null) {
                    resourceBase
                            .setResourceItem(new BlancoResourceBundleCombineResourceItem());
                }
            }

            public void endElementResource(String uri, String localName,
                    String qName) throws SAXException {
                try {
                    if (resourceBase != null) {
                        if (resourceBase.getListResouce() != null) {
                            if (resourceBase.getCurrentResourceString() == null) {
                                // lĂȂꍇ(NULL̂܂)ƂƂō̂ŁA󕶎Zbg܂B
                                resourceBase.setCurrentResourceString("");
                            }
                            BlancoResourceBundleCombineResourceItem foundItem = null;
                            for (int index = 0; index < resourceBase
                                    .getListResouce().size(); index++) {
                                BlancoResourceBundleCombineResourceItem itemLook = (BlancoResourceBundleCombineResourceItem) resourceBase
                                        .getListResouce().get(index);
                                if (itemLook.getResourceKey() == null) {
                                    // XML̃RoCƂẮAǂݔ΂܂B
                                    // vpeBt@C̃RǵAƂ͕ʂ̌oH擾܂B
                                    continue;
                                }
                                if (itemLook.getResourceKey().equals(
                                        resourceBase.getResourceItem()
                                                .getResourceKey())) {
                                    foundItem = itemLook;
                                    break;
                                }
                            }
                            if (foundItem == null) {
                                resourceBase.getListResouce().add(
                                        resourceBase.getResourceItem());
                                final BlancoResourceBundleCombineResourceMessageItem item = new BlancoResourceBundleCombineResourceMessageItem();
                                item.setKey(resourceBase.getCurrentLocale());
                                item.setMessage(resourceBase
                                        .getCurrentResourceString());
                                resourceBase.getResourceItem()
                                        .getResourceList().add(item);
                            } else {
                                final BlancoResourceBundleCombineResourceMessageItem item = new BlancoResourceBundleCombineResourceMessageItem();
                                item.setKey(resourceBase.getCurrentLocale());
                                item.setMessage(resourceBase
                                        .getCurrentResourceString());
                                foundItem.getResourceList().add(item);
                            }
                        }
                        // \[X͂pς݂Ȃ̂ NA܂B
                        resourceBase.setCurrentResourceString(null);
                    }
                } catch (Exception ex) {
                    ex.printStackTrace();
                    throw new SAXException(ex);
                }
            }

            public void charactersResource(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceResource(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementNo(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementNo(String uri, String localName, String qName)
                    throws SAXException {
            }

            public void charactersNo(char[] ch, int start, int length)
                    throws SAXException {
                if (resourceBase != null
                        && resourceBase.getResourceItem() != null) {
                    resourceBase.getResourceItem().setNo(
                            new String(ch, start, length));
                }
            }

            public void ignorableWhitespaceNo(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void startElementResourceKey(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementResourceKey(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersResourceKey(char[] ch, int start, int length)
                    throws SAXException {
                try {
                    if (resourceBase != null
                            && resourceBase.getResourceItem() != null) {
                        resourceBase.getResourceItem().setResourceKey(
                                new String(ch, start, length));
                    }
                } catch (Exception ex) {
                    ex.printStackTrace();
                    throw new SAXException(ex);
                }
            }

            public void ignorableWhitespaceResourceKey(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementResourceString(String uri,
                    String localName, String qName, String attrLocale)
                    throws SAXException {
            }

            public void endElementResourceString(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersResourceString(char[] ch, int start,
                    int length) throws SAXException {
                if (resourceBase != null) {
                    resourceBase.setCurrentResourceString(new String(ch, start,
                            length));
                }
            }

            public void ignorableWhitespaceResourceString(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementDescription(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementDescription(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersDescription(char[] ch, int start, int length)
                    throws SAXException {
                if (resourceBase != null) {
                    resourceBase.setDescription(new String(ch, start, length));
                }
            }

            public void ignorableWhitespaceDescription(char[] ch, int start,
                    int length) throws SAXException {
            }

        });

        InputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(
                    fileXmlSource));
            final TransformerFactory tf = TransformerFactory.newInstance();
            final Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }
}
