/*
 * blancoResourceBundle Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.resourcebundle;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import blanco.commons.util.BlancoXmlUtil;
import blanco.resourcebundle.expand.BlancoResourceBundleExpandResourceBundle;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * blancoResourceBundle <br>
 * ^񂩂vpeBt@C⃊\[XohANZTJava\[XR[h <br>
 * 
 * XML͂JavaNXE\[XR[h܂B <br>
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleXml2JavaClass {
    private final BlancoResourceBundleResourceBundle bundle = new BlancoResourceBundleResourceBundle();

    public void process(final File fileSource, final File directoryTarget) {
        final DOMResult result = BlancoXmlUtil.transformFile2Dom(fileSource);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            final HashMap mapProcessedBaseName = new HashMap(64);
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);
                // System.out.println("V[g[" + elementSheet.getAttribute("name")
                // + "]B");

                final NodeList listCommon = elementSheet
                        .getElementsByTagName("blancoresourcebundle-common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final Element elementCommon = (Element) listCommon.item(0);
                final String baseName = BlancoXmlUtil.getTextContent(
                        elementCommon, BlancoResourceBundleConstants.BASE_NAME);
                if (baseName == null) {
                    continue;
                }

                if (BlancoXmlUtil.getTextContent(elementCommon,
                        BlancoResourceBundleConstants.PACKAGE_NAME) == null) {
                    continue;
                }

                final ArrayList listLocale = new ArrayList();
                final NodeList nodeListCommon = elementCommon
                        .getElementsByTagName(BlancoResourceBundleConstants.LOCALE);
                for (int indexLocale = 0; indexLocale < nodeListCommon
                        .getLength(); indexLocale++) {
                    final Node nodeLook = nodeListCommon.item(indexLocale);
                    if (nodeLook instanceof Element) {
                        final Element elementLook = (Element) nodeLook;
                        final NodeList nodeChields = elementLook
                                .getChildNodes();
                        for (int indexChild = 0; indexChild < nodeChields
                                .getLength(); indexChild++) {
                            final Node nodeChild = nodeChields.item(indexChild);
                            if (nodeChild instanceof Text) {
                                listLocale.add(((Text) nodeChild)
                                        .getNodeValue());
                            }
                        }
                    }
                }
                if (listLocale.size() == 0) {
                    continue;
                }

                if (mapProcessedBaseName.get(baseName) != null) {
                    throw new IllegalArgumentException(
                            bundle
                                    .getXml2javaclassErr001(baseName,
                                            (String) mapProcessedBaseName
                                                    .get(baseName)));
                }
                expandSheet(elementSheet, elementCommon, directoryTarget);
                mapProcessedBaseName.put(baseName, "܂");
            }
        }
    }

    private static void expandSheet(final Element elementSheet,
            final Element elementCommon, final File directoryTarget) {
        new BlancoResourceBundleExpandResourceBundle().expand(elementSheet,
                elementCommon, directoryTarget);
    }
}