/*
 * blancoResourceBundle Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.resourcebundle;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.io.Native2AsciiWriter;
import blanco.commons.util.BlancoXmlUtil;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * blancoResourceBundle <br>
 * ^񂩂vpeBt@C⃊\[XohANZTJava\[XR[h <br>
 * 
 * XML͂ăvpeBt@Cɏo͂s܂B <br>
 * vpeBt@CdlƂĎQƂ񌹂͉LPropertiesNX <br>
 * http://java.sun.com/j2se/1.5.0/docs/api/java/util/Properties.html#store(java.io.OutputStream,%20java.lang.String)
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleXml2Properties {
    private BlancoResourceBundleResourceBundle bundle = new BlancoResourceBundleResourceBundle();

    /**
     * ^CX^vvpeBt@C̃Rgɏo͂邩ǂB
     */
    private boolean fCommentTimestamp = true;

    public void setCommentTimestamp(final boolean isCommentTimestamp) {
        fCommentTimestamp = isCommentTimestamp;
    }

    public void process(final File fileSource, final File directoryTarget) {
        final DOMResult result = BlancoXmlUtil.transformFile2Dom(fileSource);

        if (directoryTarget.exists() == false) {
            // fBNĝŐVK쐬܂B
            directoryTarget.mkdirs();
        }

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            final HashMap mapProcessedBaseName = new HashMap(64);
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                final NodeList listCommon = elementSheet
                        .getElementsByTagName("blancoresourcebundle-common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final Element elementCommon = (Element) listCommon.item(0);

                final String baseName = BlancoXmlUtil.getTextContent(
                        elementCommon, BlancoResourceBundleConstants.BASE_NAME);
                if (baseName == null) {
                    continue;
                }

                if (BlancoXmlUtil.getTextContent(elementCommon,
                        BlancoResourceBundleConstants.PACKAGE_NAME) == null) {
                    continue;
                }

                final String locale = BlancoXmlUtil.getTextContent(
                        elementCommon, BlancoResourceBundleConstants.LOCALE);
                if (locale == null) {
                    continue;
                }

                if (mapProcessedBaseName.get(baseName) == null) {
                    // System.out.println("ꖼ[" + baseName + "]
                    // ߂ēoꂵ܂BP[["
                    // + locale + "]̓P[w肳ĂȂꍇ̃\[XƂĂp܂B");
                    expandSheet(elementSheet, elementCommon, null,
                            directoryTarget);
                    mapProcessedBaseName.put(baseName, locale);
                }
                expandSheet(elementSheet, elementCommon, locale,
                        directoryTarget);
            }
        }
    }

    /**
     * V[gWJ܂B
     * 
     * @param elementSheet
     * @param elementCommon
     * @param locale
     * @param directoryTarget
     */
    private void expandSheet(final Element elementSheet,
            final Element elementCommon, final String locale,
            final File directoryTarget) {
        final String resourceDefinitionId = BlancoXmlUtil.getTextContent(
                elementCommon, BlancoResourceBundleConstants.BASE_NAME);

        final String fileName = (locale == null ? directoryTarget
                .getAbsolutePath()
                + "/" + resourceDefinitionId + ".properties" : directoryTarget
                .getAbsolutePath()
                + "/" + resourceDefinitionId + "_" + locale + ".properties");

        Native2AsciiWriter writer = null;
        try {

            // vpeBt@C 8859_1ŃGR[hĂ܂B
            writer = new Native2AsciiWriter(new BufferedWriter(
                    new OutputStreamWriter(new FileOutputStream(fileName),
                            "8859_1")));

            writer
                    .writeComment(" blancoResourceBundle properties file for locale ["
                            + (locale == null ? "default" : locale) + "]");

            if (fCommentTimestamp) {
                writer.writeComment(" generated at "
                        + DateFormat.getDateInstance().format(new Date()) + " "
                        + DateFormat.getTimeInstance().format(new Date()));
            }

            final NodeList listResourceList = elementSheet
                    .getElementsByTagName("blancoresourcebundle-resourceList");
            // w肪ꍇłĂAt@C͐܂B

            final NodeList listResource = ((Element) listResourceList.item(0))
                    .getElementsByTagName("resource");
            final int sizeListRow = listResource.getLength();
            for (int indexField = 0; indexField < sizeListRow; indexField++) {
                final Element elementResource = (Element) listResource
                        .item(indexField);

                final String fieldResourceId = BlancoXmlUtil.getTextContent(
                        elementResource,
                        BlancoResourceBundleConstants.RESOURCE_KEY);
                final String fieldResourceString = BlancoXmlUtil
                        .getTextContent(elementResource,
                                BlancoResourceBundleConstants.RESOURCE_STRING);
                if (fieldResourceId == null) {
                    // \[XIDnull̏ꍇ vpeBł͂܂B
                    if (fieldResourceString != null) {
                        // \[XIDnullȂ̂ǂ񂪎w肳Ăꍇɂ
                        // RgƂĈ܂B
                        writer.writeComment(fieldResourceString);
                    }
                } else {
                    writer.writeProperty(bundle.getKeyPrefix()
                            + fieldResourceId,
                            (fieldResourceString == null ? ""
                                    : fieldResourceString));
                }
            }
        } catch (IOException e) {
            throw new IllegalArgumentException("vpeBt@C[" + fileName
                    + "]̏o͎ɓo͗O܂B" + e.toString());
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}