/*
 * blancoResourceBundle Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.resourcebundle.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import org.apache.tools.ant.BuildException;

import blanco.resourcebundle.BlancoResourceBundleMeta2Xml;
import blanco.resourcebundle.BlancoResourceBundleXml2CombinedXml;
import blanco.resourcebundle.BlancoResourceBundleXml2JavaClass;
import blanco.resourcebundle.BlancoResourceBundleXml2Properties;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * BlancoResourceBundle Ant Task
 */
public class BlancoResourceBundleTask extends AbstractBlancoResourceBundleTask {
    private final BlancoResourceBundleResourceBundle bundle = new BlancoResourceBundleResourceBundle();

    protected void process() throws IllegalArgumentException {
        try {
            final File blancoTmpResourceBundleDirectory = new File(getTmpdir()
                    + "/resourcebundle");
            blancoTmpResourceBundleDirectory.mkdirs();

            File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new BuildException(bundle.getTaskErr001(getMetadir()));
            }

            // xlst@Cxmlt@Cւƕϊ܂B
            new BlancoResourceBundleMeta2Xml().processDirectory(fileMetadir,
                    blancoTmpResourceBundleDirectory.getAbsolutePath());

            // e|tH_XMLt@Cgݑւ combinedxmlt@C𐶐܂B
            final File[] fileMeta = blancoTmpResourceBundleDirectory
                    .listFiles();
            for (int index = 0; index < fileMeta.length; index++) {
                if (fileMeta[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                final File fileTmpTargetCombine = new File(
                        blancoTmpResourceBundleDirectory + "/"
                                + fileMeta[index].getName() + ".combinedxml");
                // XMLt@C̑gݑւs܂B
                new BlancoResourceBundleXml2CombinedXml().process(
                        fileMeta[index], fileTmpTargetCombine);
            }

            final File[] fileTmp = blancoTmpResourceBundleDirectory.listFiles();
            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".combinedxml")) {
                    if (bundle.getGenerateSource().equals("true")) {
                        new BlancoResourceBundleXml2JavaClass().process(
                                fileTmp[index], new File(getTargetdir()));
                    }
                } else if (fileTmp[index].getName().endsWith(".xml")) {
                    final BlancoResourceBundleXml2Properties xml2properties = new BlancoResourceBundleXml2Properties();
                    xml2properties.setCommentTimestamp(getCommenttimestamp()
                            .equals("true"));
                    xml2properties.process(fileTmp[index], new File(
                            getTargetdir() + "/main"));
                }
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (TransformerException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }
}
