/*
 * blancoCommons Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BlancoFileUtil {
    private static final boolean IS_DEUBG = true;

    /**
     * ^ꂽt@CRs[܂B<br>
     * 
     * @param fileSource
     * @param fileTarget
     * @throws IOException
     */
    public static final void copy(final File fileSource, final File fileTarget)
            throws IOException {
        if (IS_DEUBG) {
            System.out.println("BlancoFileUtil.copy("
                    + fileSource.getAbsolutePath() + ", "
                    + fileTarget.getAbsolutePath() + ")");
        }
        if (fileSource == null) {
            throw new IllegalArgumentException("̓t@Cnull^܂B");
        }
        if (fileTarget == null) {
            throw new IllegalArgumentException("o̓t@Cnull^܂B");
        }
        if (fileSource.exists() == false) {
            throw new IllegalArgumentException("̓t@C["
                    + fileSource.getAbsolutePath() + "]܂B");
        }
        if (fileSource.isFile() == false) {
            throw new IllegalArgumentException("̓t@C["
                    + fileSource.getAbsolutePath() + "]ɃfBNg^邱Ƃ͂ł܂B");
        }
        if (fileTarget.exists()) {
            if (fileTarget.isFile() == false) {
                throw new IllegalArgumentException("o̓t@C["
                        + fileSource.getAbsolutePath()
                        + "]ɃfBNg^邱Ƃ͂ł܂B");
            }
            if (fileTarget.canWrite() == false) {
                throw new IllegalArgumentException("o̓t@C["
                        + fileSource.getAbsolutePath()
                        + "]݂ɁA݂sƂł܂B");
            }
        }

        final File fileTargetParent = fileTarget.getParentFile();
        if (fileTargetParent.exists() == false) {
            // ݂Ȃꍇɂ͍쐬܂B
            if (fileTargetParent.mkdirs() == false) {
                throw new IllegalArgumentException("o̓t@C["
                        + fileSource.getAbsolutePath() + "]̐etH_["
                        + fileTargetParent.getAbsolutePath()
                        + "]݂Ȃ̂ō쐬悤Ƃ܂쐬Ɏs܂B");
            }
        }

        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(fileSource));
            outStream = new BufferedOutputStream(new FileOutputStream(
                    fileTarget));
            copy(inStream, outStream);
            outStream.flush();
        } finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            } finally {
                if (outStream != null) {
                    outStream.close();
                }
            }
        }
    }

    /**
     * ^ꂽXg[Rs[܂B<br>
     * tbV͍s܂B
     * 
     * @param inStream
     * @param outStream
     * @throws IOException
     */
    public static final void copy(final InputStream inStream,
            final OutputStream outStream) throws IOException {
        final byte[] buf = new byte[8192];
        for (;;) {
            final int length = inStream.read(buf, 0, buf.length);
            if (length < 0) {
                break;
            }
            outStream.write(buf, 0, length);
        }
    }
}
