/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.collector;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.SAXException;

import blanco.db.concretesax.BlancoDbXmlHandler;
import blanco.db.conf.AbstractQuery;
import blanco.db.conf.BlancoDbMetadata;
import blanco.db.conf.CallQuery;
import blanco.db.conf.ExecuteQuery;
import blanco.db.conf.SelectQuery;
import blanco.db.definition.BlancoDbDefinition;
import blanco.db.definition.FieldFactory;
import blanco.db.definition.QueryCaller;
import blanco.db.definition.QueryInvoker;
import blanco.db.definition.QueryIterator;
import blanco.db.mapping.BlancoDbMappingUtil;
import blanco.db.resourcebundle.BlancoDbResourceBundle;
import blanco.db.util.BlancoDbQueryParserUtil;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoDbCollector {
    private final BlancoDbResourceBundle bundle = new BlancoDbResourceBundle();

    /**
     * TableGatewayȊOW܂B
     * 
     * @param metadata
     * @param conn
     * @return
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws BlancoDbException
     * @throws TransformerException
     */
    public BlancoDbDefinition collect(final BlancoDbMetadata metadata,
            final BlancoDbDatabaseConnection conn) throws SQLException,
            SAXException, IOException, ParserConfigurationException,
            TransformerException {
        final BlancoDbDefinition _definition = new BlancoDbDefinition("NoName");
        _definition.setIteratorList(new ArrayList());
        _definition.setInvokerList(new ArrayList());
        _definition.setCallerList(new ArrayList());

        final SAXResult result = new SAXResult(new BlancoDbXmlHandler() {
            /**
             * ^m肷܂ł́AɊi[Ă܂B
             */
            private AbstractQuery abstractQuery = null;

            private String queryType = null;

            private String sqlScrollType = null;

            private String sqlUpdatable = null;

            private boolean isInParameter = false;

            private boolean isOutParameter = false;

            private String paramNo = null;

            private String paramName = null;

            private String paramType = null;

            public void startElementWorkbook(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementWorkbook(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersWorkbook(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceWorkbook(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementSheet(String uri, String localName,
                    String qName, String attrName) throws SAXException {
                // Ôߏ܂B
                abstractQuery = null;
                queryType = null;
                sqlScrollType = null;
                sqlUpdatable = null;
                isInParameter = false;
                isOutParameter = false;
                paramNo = null;
                paramName = null;
                paramType = null;
            }

            public void endElementSheet(String uri, String localName,
                    String qName) throws SAXException {
                try {
                    if (abstractQuery == null) {
                        return;
                    }
                    if (abstractQuery.getName() == null
                            || abstractQuery.getName().length() == 0) {
                        // SQL`IDw肳ĂȂ̂͏܂B
                        return;
                    }
                    if (abstractQuery.getQuery() == null
                            || abstractQuery.getQuery().length() == 0) {
                        // SQL擾łȂ̂̓G[܂B
                        throw new IllegalArgumentException(
                                bundle.getXml2javaclassErr001(abstractQuery
                                        .getName()));
                    }

                    if (abstractQuery instanceof SelectQuery) {
                        try {
                            getQueryFields(conn.getConnection(),
                                    (SelectQuery) abstractQuery);
                        } catch (SQLException e) {
                            throw new IllegalArgumentException(bundle
                                    .getXml2javaclassErr002(abstractQuery
                                            .getName(), e.getSQLState(),
                                            new BigDecimal(e.getErrorCode()), e
                                                    .toString()));
                        }
                        _definition.addQueryIterator(new QueryIterator(
                                (SelectQuery) abstractQuery));
                    } else if (abstractQuery instanceof ExecuteQuery) {
                        _definition.addQueryInvoker(new QueryInvoker(
                                (ExecuteQuery) abstractQuery));
                    } else if (abstractQuery instanceof CallQuery) {
                        _definition.addQueryCaller(new QueryCaller(
                                (CallQuery) abstractQuery));
                    } else {
                        throw new IllegalArgumentException(bundle
                                .getXml2javaclassErr003(abstractQuery
                                        .toString(), abstractQuery.getClass()
                                        .toString()));
                    }
                } finally {
                    // pÎŏ܂B
                    abstractQuery = null;
                }
            }

            public void charactersSheet(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceSheet(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementBlancodbCommon(String uri,
                    String localName, String qName) throws SAXException {
                // ŃCX^X𐶐Ă܂B
                abstractQuery = new AbstractQuery();
            }

            public void endElementBlancodbCommon(String uri, String localName,
                    String qName) throws SAXException {
                if (abstractQuery == null) {
                    return;
                }

                // blancodb-commonGgIƂɁASQL`̑Se킩܂B
                if (abstractQuery.getName() == null || queryType == null) {
                    // ̒`͏̕Kv܂BȂƂƂ܂B
                    abstractQuery = null;
                    return;
                }

                final AbstractQuery wrk = abstractQuery;
                if (queryType.equals("iterator")) {
                    abstractQuery = new SelectQuery(wrk.getName(), wrk
                            .getFilePath());
                    ((SelectQuery) abstractQuery)
                            .setScrollInterface(sqlScrollType);
                    ((SelectQuery) abstractQuery)
                            .setEnableUpdatableInterface("true"
                                    .equals((sqlUpdatable)));
                } else if (queryType.equals("invoker")) {
                    abstractQuery = new ExecuteQuery(wrk.getName(), wrk
                            .getFilePath());
                } else if (queryType.equals("caller")) {
                    abstractQuery = new CallQuery(wrk.getName(), wrk
                            .getFilePath());
                } else {
                    // ł܂Bf܂B
                    abstractQuery = null;
                    return;
                }

                // ʕRs[܂B
                abstractQuery.setDescription(wrk.getDescription());
                abstractQuery.setSingle(wrk.isSingle());
            }

            public void charactersBlancodbCommon(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceBlancodbCommon(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementQueryType(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementQueryType(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersQueryType(char[] ch, int start, int length)
                    throws SAXException {
                queryType = new String(ch, 0, length);
            }

            public void ignorableWhitespaceQueryType(char[] ch, int start,
                    int length) throws SAXException {

            }

            public void startElementSingle(String uri, String localName,
                    String qName) throws SAXException {

            }

            public void endElementSingle(String uri, String localName,
                    String qName) throws SAXException {

            }

            public void charactersSingle(char[] ch, int start, int length)
                    throws SAXException {
                if (abstractQuery == null) {
                    return;
                }

                final String single = new String(ch, 0, length);
                if (single.equals("true")) {
                    abstractQuery.setSingle(true);
                } else {
                    abstractQuery.setSingle(false);
                }
            }

            public void ignorableWhitespaceSingle(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementName(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementName(String uri, String localName,
                    String qName) throws SAXException {

            }

            public void charactersName(char[] ch, int start, int length)
                    throws SAXException {
                if (abstractQuery == null) {
                    return;
                }

                if (isInParameter == false && isOutParameter == false) {
                    abstractQuery.setName(new String(ch, 0, length));
                } else {
                    paramName = new String(ch, 0, length);
                }
            }

            public void ignorableWhitespaceName(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void startElementScroll(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementScroll(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersScroll(char[] ch, int start, int length)
                    throws SAXException {
                sqlScrollType = new String(ch, start, length);
            }

            public void ignorableWhitespaceScroll(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementUpdatable(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementUpdatable(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersUpdatable(char[] ch, int start, int length)
                    throws SAXException {
                sqlUpdatable = new String(ch, start, length);
            }

            public void ignorableWhitespaceUpdatable(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementBlancodbInparameters(String uri,
                    String localName, String qName) throws SAXException {
                isInParameter = true;
            }

            public void endElementBlancodbInparameters(String uri,
                    String localName, String qName) throws SAXException {
                isInParameter = false;
            }

            public void charactersBlancodbInparameters(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceBlancodbInparameters(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void startElementInparameter(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementInparameter(String uri, String localName,
                    String qName) throws SAXException {
                if (abstractQuery == null) {
                    return;
                }

                final String paramNoString = (paramNo == null ? "" : " No.["
                        + paramNo + "] ");
                if (paramName == null || paramName.length() == 0) {
                    throw new IllegalArgumentException(bundle
                            .getXml2javaclassErr004(abstractQuery.getName(),
                                    paramNoString, paramType));
                }
                if (paramType == null || paramType.length() == 0) {
                    throw new IllegalArgumentException(bundle
                            .getXml2javaclassErr005(abstractQuery.getName(),
                                    paramNoString, paramName));
                }

                Value value = new Value(new Type(paramType), paramName);
                abstractQuery.addInParameter(value);

            }

            public void charactersInparameter(char[] ch, int start, int length)
                    throws SAXException {

            }

            public void ignorableWhitespaceInparameter(char[] ch, int start,
                    int length) throws SAXException {

            }

            public void startElementNo(String uri, String localName,
                    String qName) throws SAXException {

            }

            public void endElementNo(String uri, String localName, String qName)
                    throws SAXException {

            }

            public void charactersNo(char[] ch, int start, int length)
                    throws SAXException {
                paramNo = new String(ch, start, length);
            }

            public void ignorableWhitespaceNo(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void startElementType(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementType(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersType(char[] ch, int start, int length)
                    throws SAXException {
                paramType = new String(ch, start, length);
            }

            public void ignorableWhitespaceType(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void startElementDescription(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementDescription(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersDescription(char[] ch, int start, int length)
                    throws SAXException {
                if (abstractQuery == null) {
                    return;
                }

                abstractQuery.setDescription(new String(ch, 0, length));
            }

            public void ignorableWhitespaceDescription(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementSamplevalue(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementSamplevalue(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersSamplevalue(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceSamplevalue(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementBlancodbOutparameters(String uri,
                    String localName, String qName) throws SAXException {
                isOutParameter = true;
            }

            public void endElementBlancodbOutparameters(String uri,
                    String localName, String qName) throws SAXException {
                isOutParameter = false;
            }

            public void charactersBlancodbOutparameters(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceBlancodbOutparameters(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void startElementOutparameter(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementOutparameter(String uri, String localName,
                    String qName) throws SAXException {
                if (abstractQuery == null) {
                    return;
                }

                final String paramNoString = (paramNo == null ? "" : " No.["
                        + paramNo + "] ");
                if (paramName == null || paramName.length() == 0) {
                    throw new IllegalArgumentException(bundle
                            .getXml2javaclassErr006(abstractQuery.getName(),
                                    paramNoString, paramType));
                }
                if (paramType == null || paramType.length() == 0) {
                    throw new IllegalArgumentException(bundle
                            .getXml2javaclassErr007(abstractQuery.getName(),
                                    paramNoString, paramName));
                }
                if (abstractQuery instanceof CallQuery == false) {
                    throw new IllegalArgumentException(bundle
                            .getXml2javaclassErr008(abstractQuery.getName(),
                                    paramNoString, paramName));
                }

                Value value = new Value(new Type(paramType), paramName);
                ((CallQuery) abstractQuery).addOutParameter(value);
            }

            public void charactersOutparameter(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceOutparameter(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementBlancodbQuery(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementBlancodbQuery(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersBlancodbQuery(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceBlancodbQuery(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementQueryLine(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementQueryLine(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersQueryLine(char[] ch, int start, int length)
                    throws SAXException {
                if (abstractQuery == null) {
                    return;
                }

                String query = abstractQuery.getQuery();
                if (query == null || query.length() == 0) {
                    query = "";
                } else {
                    // 񂪂łɑ݂Ăꍇɂ̂݉st^܂B
                    query = query + "\n";
                }
                abstractQuery.setQuery(query + new String(ch, start, length));
            }

            public void ignorableWhitespaceQueryLine(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startDocument() throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void startElementBlancodbDetail(String uri,
                    String localName, String qName) throws SAXException {
            }

            public void endElementBlancodbDetail(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersBlancodbDetail(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceBlancodbDetail(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementDetailLine(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementDetailLine(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersDetailLine(char[] ch, int start, int length)
                    throws SAXException {
                // ŋLB
            }

            public void ignorableWhitespaceDetailLine(char[] ch, int start,
                    int length) throws SAXException {
            }
        });

        InputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(metadata
                    .getXml()));
            final TransformerFactory tf = TransformerFactory.newInstance();
            final Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } finally {
            if (inStream != null) {
                inStream.close();
            }
        }

        return _definition;
    }

    /**
     * SQLsʂ̌ʗꗗ擾āȀL܂B<br>
     * blancoDb̊jƂ@\ł
     * 
     * @param callQuery
     * @return
     * @throws BlancoDbException
     * @throws SQLException
     */
    private final void getQueryFields(final Connection conn,
            final SelectQuery selectQuery) throws SQLException {
        final BlancoDbQueryParserUtil parserUtil = new BlancoDbQueryParserUtil(
                selectQuery.getQuery());

        PreparedStatement _statement = null;
        ResultSet _resultSet = null;
        ResultSetMetaData meta = null;

        final FieldFactory _factory = new FieldFactory();
        try {
            _statement = conn
                    .prepareStatement(parserUtil.getNaturalSqlString());

            // ŃoCh{B
            // 2005.05.20 t.iga
            for (Iterator iteParameter = selectQuery.getInParameterIterator(); iteParameter
                    .hasNext();) {
                final Value val = (Value) iteParameter.next();
                int[] listCol = parserUtil.getSqlParameters(val.getName());
                if (listCol == null) {
                    throw new IllegalArgumentException(bundle
                            .getXml2javaclassErr009(selectQuery.getName(), val
                                    .getName()));
                }
                for (int iteSame = 0; iteSame < listCol.length; iteSame++) {
                    final int index = listCol[iteSame];
                    BlancoDbMappingUtil.processPreparedStatementWithSomeValue(
                            val.getType().getName(), _statement, index);
                }
            }

            _resultSet = _statement.executeQuery();
            meta = _resultSet.getMetaData();
            for (int i = 0; i < meta.getColumnCount(); i++) {
                selectQuery.addField(_factory.createQueryField(i + 1, meta));
            }
        } finally {
            if (_resultSet != null) {
                _resultSet.close();
            }
            if (_statement != null) {
                _statement.close();
            }
        }
    }
}