/*
 * blancoDb
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import blanco.db.definition.QueryIterator;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author tosiki iga
 */
public class PrepareStatementMethod2 extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private Value queryArgument = new Value(String.class, "query");

    private QueryIterator _iterator = null;

    public PrepareStatementMethod2(final BlancoDbObjectStorage storage,
            final QueryIterator iterator) {
        super("prepareStatement");
        this.storage = storage;
        _iterator = iterator;
    }

    public void setupSignature() {
        // ǉĂ݂B
        addArgument(queryArgument);

        getJavaDoc().addException(new Type("java.sql.SQLException"),
                "SQLOꍇB");
        addException(new Type("java.sql.SQLException"));

        getJavaDoc().addLine("^ꂽSQLăvRpC{(ISQL)܂B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine(
                "Iɓeω悤SQLsKvꍇɂ̂݁Ã\bh𗘗p܂B<br>");
        getJavaDoc()
                .addLine(
                        "ł͂Ȃꍇɂ́Ã\bh̗p͔ prepareStatement()\bh (Ȃ)ĂяoĂB<br>");
        getJavaDoc()
                .addLine(
                        "ȂȂÃ\bhłSQL̂̂p[^Ƃė^邱ƂłĎRxASQLCWFNVƌĂ΂ZLeBz[\NĂ܂łB<br>");
        getJavaDoc().addLine("IConnection.prepareStatementĂяo܂B<br>");

        if (_iterator == null) {
        } else if (_iterator.getScrollInterface().equals("forward_only")
                && _iterator.isEnableUpdatableInterface() == false) {
        } else {
            getJavaDoc().addLine("XN[: " + _iterator.getScrollInterface());
            if (_iterator.isEnableUpdatableInterface()) {
                getJavaDoc().addLine("XV\: L");
            }
        }

        getJavaDoc().addParameter("query",
                "vRpC{SQLBISQL̏ꍇɂ́Äɂ͉Hꂽ̎s\SQL^܂B");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName()
                    + ": query = \" + query);");
            implementor.addLine("}");
            implementor.addLine("");
        }

        implementor.addStatement("close()");

        if (_iterator == null) {
            implementor
                    .addStatement("fStatement = fConnection.prepareStatement(query)");
        } else if (_iterator.getScrollInterface().equals("forward_only")
                && _iterator.isEnableUpdatableInterface() == false) {
            // p[^̃oG[VPȏꍇɂ́APprepareStatementĂяoB
            implementor
                    .addStatement("fStatement = fConnection.prepareStatement(query)");
        } else {
            String resultSetType = "ResultSet.TYPE_FORWARD_ONLY";
            String resultSetConcurrency = "ResultSet.CONCUR_READ_ONLY";
            if (_iterator.getScrollInterface().equals("insensitive")) {
                resultSetType = "ResultSet.TYPE_SCROLL_INSENSITIVE";
            } else if (_iterator.getScrollInterface().equals("sensitive")) {
                resultSetType = "ResultSet.TYPE_SCROLL_SENSITIVE";
            }
            if (_iterator.isEnableUpdatableInterface()) {
                resultSetConcurrency = "ResultSet.CONCUR_UPDATABLE";
            }
            implementor
                    .addStatement("fStatement = fConnection.prepareStatement(query, "
                            + resultSetType + ", " + resultSetConcurrency + ")");
        }
    }
}