/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import blanco.db.definition.QueryIterator;
import blanco.db.exception.NoRowFoundExceptionClass;
import blanco.db.exception.TooManyRowsFoundExceptionClass;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;

/**
 * VOtruȅꍇɂ̂݁ÃNX͗p܂
 * 
 * @author Tosiki Iga
 */
public class GetSingleRowMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private Value _result = null;

    private String runtimePackage = null;

    public GetSingleRowMethod(final BlancoDbObjectStorage storage,
            final Type rowObjectType, final QueryIterator iterator) {
        super("getSingleRow");
        this.storage = storage;

        _result = new Value(rowObjectType, "result");

        // ^CpbP[W̕ωɑΉB
        runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }
    }

    public void setupSignature() {
        setReturnType(_result.getType());

        final Type noRowFoundException = new Type(runtimePackage
                + ".exception.NoRowFoundException");
        getJavaDoc().addException(noRowFoundException,
                "f[^x[X̏̌ʁA1sf[^ȂꍇB");
        addException(noRowFoundException);
        final Type tooManyRowsFoundException = new Type(runtimePackage
                + ".exception.TooManyRowsFoundException");
        getJavaDoc().addException(tooManyRowsFoundException,
                "f[^x[X̏̌ʁA1s𒴂f[^Ă܂ꍇB");
        addException(tooManyRowsFoundException);

        getJavaDoc().addException(new Type("java.sql.SQLException"),
                "SQLOꍇB");
        addException(new Type("java.sql.SQLException"));

        getJavaDoc().addLine("݂̍s̃f[^IuWFNgƂĎ擾܂B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine(
                "SQL̎sʂ1sł邱ƂmF܂Bsʂ1sȊOłꍇɂ͗O𔭐܂B<br>");
        getJavaDoc().addLine("VOLƂȂĂ̂Ő܂B<br>");

        getJavaDoc().addReturn("sIuWFNgB");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        final Type exceptionType = new Type(runtimePackage + ".exception",
                NoRowFoundExceptionClass.CLASS_NAME);

        implementor.openIf("next() == false");
        Call c = new Call(exceptionType);
        c.addArgument(new StringLiteral("f[^x[X̏̌ʁA1sf[^܂łB"));
        implementor.addThrow(c);
        implementor.closeIf();

        implementor.emptyLine();

        implementor.addStatement(_result.getType().getName()
                + " result = getRow()");
        implementor.emptyLine();

        Type exeptionType = new Type(runtimePackage + ".exception",
                TooManyRowsFoundExceptionClass.CLASS_NAME);

        // 1s𒴂ĕύXǂ`FbNB
        implementor.openIf("next()");
        Call c2 = new Call(exeptionType);
        c2.addArgument(new StringLiteral("f[^x[X̏̌ʁA1s𒴂f[^܂B"));
        implementor.addThrow(c2);
        implementor.closeIf();

        implementor.emptyLine();

        implementor.addReturn(_result);
    }
}