/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.db.BlancoDbMeta2Xml;
import blanco.db.BlancoDbTableMeta2Xml;
import blanco.db.BlancoDbXml2JavaClass;
import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;
import blanco.db.resourcebundle.BlancoDbResourceBundle;

/**
 * BlancoDb Ant Task
 */
public class BlancoDbTask extends AbstractBlancoDbTask {
    private final BlancoDbResourceBundle bundle = new BlancoDbResourceBundle();

    protected void process() throws IllegalArgumentException {
        try {
            final File blancoSqlDirectory = new File(getMetadir());
            final File blancoTmpDbTableDirectory = new File(getTmpdir()
                    + "/db/table");
            final File blancoTmpDbSqlDirectory = new File(getTmpdir()
                    + "/db/sql");
            blancoTmpDbTableDirectory.mkdirs();
            blancoTmpDbSqlDirectory.mkdirs();

            final BlancoDbDatabaseConnectionSettingDef connDef = new BlancoDbDatabaseConnectionSettingDef();
            connDef.setJdbcDriver(getJdbcdriver());
            connDef.setJdbcUrl(getJdbcurl());
            connDef.setJdbcUser(getJdbcuser());
            connDef.setJdbcPassword(getJdbcpassword());

            if (getSchema() != null) {
                // XL[}wB
                connDef.setSchema(getSchema());
            }

            if (getTable() == null || getTable().equals("true")) {
                // SimpleTableGateway
                final BlancoDbTableMeta2Xml gateway2xml = new BlancoDbTableMeta2Xml() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                gateway2xml.process(connDef, blancoTmpDbTableDirectory);

                // XMLt@CR/O}bsO
                final BlancoDbXml2JavaClass generator = new BlancoDbXml2JavaClass() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                if (getLog().equals("true")) {
                    generator.setLogging(true);
                }
                generator.process(connDef, blancoTmpDbTableDirectory,
                        getBasepackage(), getRuntimepackage(), getTargetdir());
            }

            if (getSql() == null || getSql().equals("true")) {
                final File[] files = blancoSqlDirectory.listFiles();
                if (files != null) {
                    for (int index = 0; index < files.length; index++) {
                        // Excelt@CXMLt@C܂B
                        if (files[index].getName().endsWith(".xls") == false) {
                            continue;
                        }
                        InputStream inStream = null;
                        OutputStream outStream = null;
                        try {
                            inStream = new BufferedInputStream(
                                    new FileInputStream(files[index]));
                            outStream = new BufferedOutputStream(
                                    new FileOutputStream(
                                            blancoTmpDbSqlDirectory
                                                    .getAbsolutePath()
                                                    + "/"
                                                    + files[index].getName()
                                                    + ".xml"));
                            new BlancoDbMeta2Xml() {
                                public boolean progress(int progressCurrent,
                                        int progressTotal, String progressItem) {
                                    // trueԂ܂B
                                    return true;
                                }
                            }.process(inStream, outStream);
                            outStream.flush();
                            outStream.close();
                            outStream = null;
                            inStream.close();
                            inStream = null;
                        } finally {
                            if (inStream != null) {
                                inStream.close();
                            }
                            if (outStream != null) {
                                outStream.close();
                            }
                        }
                    }
                }
                // XMLt@CR/O}bsO
                final BlancoDbXml2JavaClass generator = new BlancoDbXml2JavaClass() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                if (getLog().equals("true")) {
                    generator.setLogging(true);
                }
                generator.process(connDef, blancoTmpDbSqlDirectory,
                        getBasepackage(), getRuntimepackage(), getTargetdir());
            }
        } catch (SQLException e) {
            throw new IllegalArgumentException(bundle.getTaskErr001()
                    + e.toString());
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(bundle.getTaskErr002()
                    + e.toString());
        } catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(bundle.getTaskErr003()
                    + e.toString());
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(bundle.getTaskErr004()
                    + e.toString());
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(bundle.getTaskErr005()
                    + e.toString());
        } catch (TransformerException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(bundle.getTaskErr006()
                    + e.toString());
        }
    }
}
