/**
 * blancoDbc[ <br>
 * DatabaseMetaData\邽߂̃[eBeBvO <br>
 * 
 * @author Tosiki Iga
 */

package blanco.db.helper.seed;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * DatabaseMetaDataXgAbv邽߂̃[eBeBNXB <br>
 */
public class BlancoDbHelperDisplayDatabaseMetaData {
    // public static final String JDBC_STRING =
    // "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    public static final String JDBC_STRING = "oracle.jdbc.driver.OracleDriver";

    // public static final String JDBC_URL =
    // "jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=Northwind";
    public static final String JDBC_URL = "jdbc:oracle:thin:@localhost:1521:orcl";

    public static final String JDBC_USERNAME = "rapidadmin";

    public static final String JDBC_PASSWORD = "rapidadmin";

    public static final void main(final String[] args) {
        Connection conn = null;
        try {
            Class.forName(JDBC_STRING);
            conn = DriverManager.getConnection(JDBC_URL, JDBC_USERNAME,
                    JDBC_PASSWORD);
            final DatabaseMetaData metadata = conn.getMetaData();
            enumTables(metadata);
        } catch (SQLException ex) {
            ex.printStackTrace();
        } catch (ClassNotFoundException ex) {
            System.out.println("JDBChCõ[hɎs܂.:" + ex.toString());
            ex.printStackTrace();
        } finally {
            try {
                conn.close();
            } catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static final void enumTables(final DatabaseMetaData metadata)
            throws SQLException {
        ResultSet resultSet = null;

        try {
            resultSet = metadata.getTables(null, "RAPIDADMIN", null, null);
            for (; resultSet.next();) {
                final String tableTyle = resultSet.getString("TABLE_TYPE");

                if (tableTyle.equals("VIEW") || tableTyle.equals("SYNONYM")) {
                    continue;
                }

                final String tableCat = resultSet.getString("TABLE_CAT");
                final String tableSchem = resultSet.getString("TABLE_SCHEM");
                final String tableName = resultSet.getString("TABLE_NAME");

                System.out.println(tableTyle + ": " + tableName + " (cat:"
                        + tableCat + ",schem:" + tableSchem + ")");

                // enumColumns(metadata, tableCat, tableSchem, tableName,
                // document, eleQuery);
            }
        } finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public static final void enumColumns(final DatabaseMetaData metadata,
            final String tableCat, final String tableSchem,
            final String tableName) throws SQLException {

        ResultSet resultSetColumns = null;
        try {
            resultSetColumns = metadata.getColumns(tableCat, tableSchem,
                    tableName, null);
            for (int iColumn = 1; resultSetColumns.next(); iColumn++) {
                System.out
                        .println("  [No."
                                + resultSetColumns.getInt("ORDINAL_POSITION")
                                + "] J:"
                                + resultSetColumns.getString("COLUMN_NAME"));

                switch (resultSetColumns.getShort("DATA_TYPE")) {
                case java.sql.Types.CHAR:
                    System.out.println("    CHAR");
                    break;
                case java.sql.Types.VARCHAR:
                    System.out.println("    VARCHAR");
                    break;
                case java.sql.Types.LONGVARCHAR:
                    System.out.println("    LONGVARCHAR");
                    break;

                case java.sql.Types.DATE:
                    System.out.println("    DATE");
                    break;
                case java.sql.Types.TIMESTAMP:
                    System.out.println("    TIMESTAMP");
                    break;
                case java.sql.Types.DECIMAL:
                    System.out.println("    DECIMAL");
                    break;
                case java.sql.Types.INTEGER:
                    System.out.println("    INTEGER");
                    break;
                case java.sql.Types.SMALLINT:
                    System.out.println("    SMALLINT");
                    break;

                default:
                    System.out.println("    T|[gÕ^Cv:"
                            + resultSetColumns.getShort("DATA_TYPE"));
                    break;
                }
                System.out.println("    TYPE_NAME:"
                        + resultSetColumns.getString("TYPE_NAME"));
                System.out.println("    COLUMN_SIZE:"
                        + resultSetColumns.getInt("COLUMN_SIZE"));

                System.out.println("    DECIMAL_DIGITS:"
                        + resultSetColumns.getInt("DECIMAL_DIGITS"));
                System.out.println("    CHAR_OCTET_LENGTH:"
                        + resultSetColumns.getInt("CHAR_OCTET_LENGTH"));

                switch (resultSetColumns.getInt("NULLABLE")) {
                case DatabaseMetaData.columnNoNulls:
                    System.out.println("    NULL");
                    break;
                case DatabaseMetaData.columnNullable:
                    System.out.println("    NULL");
                    break;
                case DatabaseMetaData.columnNullableUnknown:
                    System.out.println("    NULLs");
                    break;
                }

                final String strDefaultValue = resultSetColumns
                        .getString("COLUMN_DEF");
                if (strDefaultValue != null) {
                    System.out.println("    ftHgl:" + strDefaultValue);
                }
            }
        } finally {
            if (resultSetColumns != null) {
                resultSetColumns.close();
            }
        }
    }
}