/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.cs;

import java.util.ArrayList;

import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.cg.valueobject.BlancoCgType;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgInterface\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgInterfaceCsSourceExpander {

    /**
     * interfaceWJ܂B
     * 
     * C#.NETɂ JavaƓlȃC^tF[X݂܂B
     * 
     * @param cgInterface
     *            ΏۂƂȂC^tF[XB
     * @param argSourceLines
     *            \[XR[hB
     */
    public void transformInterface(final BlancoCgInterface cgInterface,
            final BlancoCgSourceFile argSourceFile,
            final ArrayList argSourceLines) {
        // C^tF[X̏ꍇɂ JavaꓯlɃtB[h⃁\bhpublicO܂B

        // ŏɃC^tF[XLangDocɓWJB
        if (cgInterface.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgInterface.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgInterface.getLangDoc().getTitle() == null) {
            cgInterface.getLangDoc().setTitle(cgInterface.getDescription());
        }

        //  LangDoc\[XR[h`ɓWJB
        new BlancoCgLangDocCsSourceExpander().transformLangDoc(cgInterface
                .getLangDoc(), argSourceLines);

        final StringBuffer buf = new StringBuffer();

        if (BlancoStringUtil.null2Blank(cgInterface.getAccess()).length() > 0) {
            buf.append(cgInterface.getAccess() + " ");
        }
        // staticfinal͓WJ܂B
        buf.append("interface " + cgInterface.getName());

        // ŐeNXWJB
        expandExtendClassList(cgInterface, buf);

        // |Cg: eC^tF[XWJ interfaceɂ݂͑܂B

        argSourceLines.add(buf.toString());

        argSourceLines.add("{");

        // ŃtB[hWJB
        expandFieldList(cgInterface, argSourceFile, argSourceLines);

        // Ń\bhWJB
        expandMethodList(cgInterface, argSourceFile, argSourceLines);

        argSourceLines.add("}");
    }

    /**
     * eNXWJ܂B
     * 
     * @param cgClass
     * @param buf
     */
    private void expandExtendClassList(final BlancoCgInterface cgClass,
            final StringBuffer buf) {
        for (int index = 0; index < cgClass.getExtendClassList().size(); index++) {
            final Object objType = cgClass.getExtendClassList().get(index);
            if (objType instanceof BlancoCgType == false) {
                throw new IllegalArgumentException("NX̌pƂBlancoCgTypeȊǑ^["
                        + objType.getClass().getName() + "]^܂B");
            }

            final BlancoCgType type = (BlancoCgType) objType;
            if (index == 0) {
                buf.append(" : "
                        + BlancoCgTypeCsSourceExpander.toTypeString(type));
            } else {
                // TODO C#.NETŌpxƂ邩ǂmF邱ƁB
                buf.append(", "
                        + BlancoCgTypeCsSourceExpander.toTypeString(type));
            }
        }
    }

    /**
     * ܂܂eX̃tB[hWJ܂B
     * 
     * @param cgInterface
     * @param argSourceFile
     * @param argSourceLines
     */
    private void expandFieldList(final BlancoCgInterface cgInterface,
            final BlancoCgSourceFile argSourceFile,
            final ArrayList argSourceLines) {
        if (cgInterface.getFieldList() == null) {
            // tB[h̃Xgnull^܂B
            // Ȃ炸tB[h̃XgɂArrayListZbgĂB
            throw new IllegalArgumentException("tB[h̃Xgnull^܂B");
        }

        for (int index = 0; index < cgInterface.getFieldList().size(); index++) {
            final Object objField = cgInterface.getFieldList().get(index);
            if (objField instanceof BlancoCgField == false) {
                throw new IllegalArgumentException("tB[h̃XgɃtB[hȊǑ^["
                        + objField.getClass().getName() + "]̒l^܂B");
            }
            final BlancoCgField cgField = (BlancoCgField) objField;
            new BlancoCgFieldCsSourceExpander().transformField(cgField,
                    argSourceFile, argSourceLines, true);
        }
    }

    /**
     * ܂܂eX̃\bhWJ܂B
     * 
     * @param cgInterface
     * @param argSourceFile
     * @param argSourceLines
     */
    private void expandMethodList(final BlancoCgInterface cgInterface,
            final BlancoCgSourceFile argSourceFile,
            final ArrayList argSourceLines) {
        if (cgInterface.getMethodList() == null) {
            throw new IllegalArgumentException("\bh̃Xgnull^܂B");
        }
        for (int index = 0; index < cgInterface.getMethodList().size(); index++) {
            final Object objMethod = cgInterface.getMethodList().get(index);
            if (objMethod instanceof BlancoCgMethod == false) {
                throw new IllegalArgumentException("\bh̃XgɃ\bhȊǑ^["
                        + objMethod.getClass().getName() + "]̒l^܂B");
            }
            final BlancoCgMethod cgMethod = (BlancoCgMethod) objMethod;
            new BlancoCgMethodCsSourceExpander().transformMethod(cgMethod,
                    argSourceFile, argSourceLines, true);
        }
    }
}
