/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.test.valueobject;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.generator.GeneratorSetting;
import blanco.ig.generator.ImplementGenerator;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitArrayListMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitBigDecimalMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitBooleanMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitIntegerMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitLongMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitNotSupportedMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitPrimitiveBooleanMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitPrimitiveIntMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitPrimitiveLongMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitPrimitiveShortMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitShortMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitStringMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitToStringMethod;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

public class BlancoValueObjectXml2JUnit {
    /**
     * tB[h⃁\bh̖Oό`sǂB
     */
    private boolean fNameAdjust = true;

    /**
     * ValueObject\XMLt@C JUnitpJava\[XR[h܂B
     * 
     * @param metaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param directoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗OꍇB
     * @throws TransformerException
     *             XMLϊOꍇB
     */
    public void process(final File metaXmlSourceFile, final File directoryTarget)
            throws IOException, TransformerException {
        final DOMResult result = BlancoXmlUtil
                .transformFile2Dom(metaXmlSourceFile);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                final NodeList listCommon = elementSheet
                        .getElementsByTagName("blancovalueobject-common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final Element elementCommon = (Element) listCommon.item(0);
                final String name = BlancoXmlUtil.getTextContent(elementCommon,
                        "name");
                if (name == null || name.trim().length() == 0) {
                    continue;
                }

                final BlancoValueObjectClassStructure objClassStructure = new BlancoValueObjectXml2JavaClass()
                        .parseElementSheet(elementSheet);

                /**
                 * ꂽ񂩂Java\[XR[h𐶐܂B
                 */
                processJavaSource(objClassStructure, directoryTarget);
            }
        }
    }

    /**
     * ^ꂽNXƂJava\[XR[h܂B
     * 
     * @param classInfo
     *            NX
     * @param directoryTarget
     *            Java\[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    private void processJavaSource(
            final BlancoValueObjectClassStructure classInfo,
            final File directoryTarget) throws IOException {
        final ClassExpander classExpander = new ClassExpander(new Type(
                classInfo.getPackage(), classInfo.getName() + "Test")) {
            protected void expandClassStruct() {
                setSuperClass(new Type("junit.framework.TestCase"));
                getJavaDoc().addLine(
                        "NX[" + classInfo.getName() + "]̒P̎NXB<br>");
                getJavaDoc().addLine("̃NXJUnit̃eXgP[XłB");

                for (int indexField = 0; indexField < classInfo.getListField()
                        .size(); indexField++) {
                    final BlancoValueObjectFieldStructure field = (BlancoValueObjectFieldStructure) classInfo
                            .getListField().get(indexField);

                    if (field.getName() == null) {
                        throw new IllegalArgumentException("["
                                + classInfo.getName()
                                + "] ŃtB[hw肳ĂȂ̂܂B");
                    }
                    if (field.getType() == null) {
                        throw new IllegalArgumentException("["
                                + classInfo.getName() + "] tB[h["
                                + field.getName()
                                + "]́u^vw肳Ă܂Bu^vw肵ĂB");
                    }

                    final String fieldNameAdjustered = (getNameAdjust() == false ? field
                            .getName()
                            : BlancoNameAdjuster.toClassName(field.getName()));

                    if (field.getType().equals("java.lang.String")) {
                        addMethod(new BlancoValueObjectXml2JUnitStringMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else if (field.getType().equals("boolean")) {
                        addMethod(new BlancoValueObjectXml2JUnitPrimitiveBooleanMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else if (field.getType().equals("short")) {
                        addMethod(new BlancoValueObjectXml2JUnitPrimitiveShortMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else if (field.getType().equals("int")) {
                        addMethod(new BlancoValueObjectXml2JUnitPrimitiveIntMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else if (field.getType().equals("long")) {
                        addMethod(new BlancoValueObjectXml2JUnitPrimitiveLongMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else if (field.getType().equals("java.lang.Boolean")) {
                        addMethod(new BlancoValueObjectXml2JUnitBooleanMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else if (field.getType().equals("java.lang.Short")) {
                        addMethod(new BlancoValueObjectXml2JUnitShortMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else if (field.getType().equals("java.lang.Integer")) {
                        addMethod(new BlancoValueObjectXml2JUnitIntegerMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else if (field.getType().equals("java.lang.Long")) {
                        addMethod(new BlancoValueObjectXml2JUnitLongMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else if (field.getType().equals("java.math.BigDecimal")) {
                        addMethod(new BlancoValueObjectXml2JUnitBigDecimalMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else if (field.getType().equals("java.util.ArrayList")) {
                        addMethod(new BlancoValueObjectXml2JUnitArrayListMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    } else {
                        addMethod(new BlancoValueObjectXml2JUnitNotSupportedMethod(
                                "test" + fieldNameAdjustered, classInfo, field,
                                getNameAdjust()));
                    }
                }

                addMethod(new BlancoValueObjectXml2JUnitToStringMethod(
                        classInfo));
            }
        };

        generateJUnitSource(classExpander, directoryTarget);
    }

    /**
     * ClassExpander͂ƂJava\[XR[ho͂܂B
     * 
     * @param classExpander
     * @param directoryTarget
     */
    public static void generateJUnitSource(final ClassExpander classExpander,
            final File directoryTarget) {
        final GeneratorSetting setting = new GeneratorSetting();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(directoryTarget.getAbsolutePath());
        final ImplementGenerator implementGenerator = new ImplementGenerator(
                setting);
        // 쐬NXo^܂B
        implementGenerator.addTest(classExpander);
        try {
            // ۂɃ\[XR[hs܂B
            implementGenerator.generate();
            // System.out.println("\[XR[h܂B");
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\[XR[hɓo͗O܂B:"
                    + e.toString());
        }
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂݒ肵܂B
     * 
     * @param isNameAdjust
     *            Oό`sǂB
     */
    public void setNameAdjust(final boolean isNameAdjust) {
        fNameAdjust = isNameAdjust;
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂ擾܂B
     * 
     * @return Oό`sǂB
     */
    public boolean getNameAdjust() {
        return fNameAdjust;
    }
}
