/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

package blanco.anttask.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.anttask.BlancoAntTaskMeta2Xml;
import blanco.anttask.BlancoAntTaskXml2JavaClass;
import blanco.anttask.resourcebundle.BlancoAntTaskResourceBundle;

/**
 * BlancoAntTaskꎩĝ߂Ant^XNłB
 * 
 * @author IGA Tosiki
 */
public class BlancoAntTaskTask extends AbstractBlancoAntTaskTask {
    private final BlancoAntTaskResourceBundle bundle = new BlancoAntTaskResourceBundle();

    /**
     * AntTask̏s܂B
     * 
     * ̃\bh ېeNXłAbstractBlancoAntTaskTaskNXĂяo܂B
     * 
     * @throws IllegalArgumentException
     *             e͒lȌꍇɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        try {
            final File blancoTmpAntTaskDirectory = new File(getTmpdir()
                    + "/anttask");
            blancoTmpAntTaskDirectory.mkdirs();

            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(bundle
                        .getXml2javaclassErr002(getMetadir()));
            }

            new BlancoAntTaskMeta2Xml().processDirectory(fileMetadir,
                    blancoTmpAntTaskDirectory.getAbsolutePath());

            final File[] fileTmp = blancoTmpAntTaskDirectory.listFiles();
            if (fileTmp == null) {
                // ̗Rɂt@Cꗗ̎擾ɎsꍇB
                throw new IllegalArgumentException(bundle
                        .getXml2javaclassErr003(blancoTmpAntTaskDirectory
                                .getAbsolutePath()));
            }

            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".xml")) {
                    new BlancoAntTaskXml2JavaClass().process(fileTmp[index],
                            new File(getTargetdir()));
                }
            }
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}
