/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.db.definition.QueryField;
import blanco.db.definition.TableField;
import blanco.ig.expander.Value;

/**
 * CallerC^tF[X\܂B
 * 
 * @author IGA Tosiki
 */
public class CallQuery extends AbstractQuery {
    /**
     * CallableStatementŗp܂B
     */
    private final List _outParameterList = new ArrayList();

    private final List _fieldList = new ArrayList();

    public CallQuery(final String name) {
        super(name);
    }

    public void addOutParameter(final Value value) {
        _outParameterList.add(value);
    }

    public Iterator getOutParameterIterator() {
        return _outParameterList.iterator();
    }

    public List getOutParameterList() {
        return _outParameterList;
    }

    public void addField(final QueryField field) {
        _fieldList.add(field);
    }

    public TableField getField(final int index) {
        return (TableField) _fieldList.get(index);
    }

    public int getFieldCount() {
        return _fieldList.size();
    }

    public Iterator getFieldIterator() {
        return _fieldList.iterator();
    }
}