/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import java.sql.ResultSetMetaData;
import java.sql.Types;

import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class AbstractField {
    private int _isNullable = ResultSetMetaData.columnNullableUnknown;

    /**
     * NULLł΃v~eBu^Ȃ̂NULLT|[ĝ߂ɃIuWFNg}bvĂtB[hB
     */
    private boolean _isObjectMappingForPrimitiveNullSupport = false;

    private int _size = -1;

    private int _precision = -1;

    private int _scale = -1;

    private Type _javaType = null;

    private String _jdbcName = null;

    /**
     * JDBC瓾ꂽ^Cv̂
     */
    private int _jdbcType = Types.OTHER;

    public AbstractField(final Class type, final String name) {
        this(new Type(type), name);
    }

    public AbstractField(final Type type, final String name) {
        _javaType = type;
        _jdbcName = name;
    }

    public String getJdbcName() {
        return _jdbcName;
    }

    public String getName() {
        String result = _jdbcName;
        return result;
    }

    public Type getJavaType() {
        return _javaType;
    }

    public int getJdbcType() {
        return _jdbcType;
    }

    public void setJdbcType(final int arg) {
        _jdbcType = arg;
    }

    public final String getTypeFullName() {
        return _javaType.getFullName();
    }

    public final String getTypeName() {
        return _javaType.getName();
    }

    /**
     * @return _isNullable ߂܂B
     */
    public int getNullable() {
        return _isNullable;
    }

    /**
     * @param nullable
     *            _isNullable ݒB
     */
    public void setNullable(final int nullable) {
        _isNullable = nullable;
    }

    public boolean getObjectMappingForPrimitiveNullSupport() {
        return _isObjectMappingForPrimitiveNullSupport;
    }

    public void setObjectMappingForPrimitiveNullSupport(final boolean arg) {
        _isObjectMappingForPrimitiveNullSupport = arg;
    }

    /**
     * @return _precision ߂܂B
     */
    public int getPrecision() {
        return _precision;
    }

    /**
     * @param _precision
     *            _precision ݒB
     */
    public void setPrecision(final int _precision) {
        this._precision = _precision;
    }

    /**
     * @return _scale ߂܂B
     */
    public int getScale() {
        return _scale;
    }

    /**
     * @param _scale
     *            _scale ݒB
     */
    public void setScale(final int _scale) {
        this._scale = _scale;
    }

    /**
     * @return _size ߂܂B
     */
    public int getSize() {
        return _size;
    }

    /**
     * @param _size
     *            _size ݒB
     */
    public void setSize(final int _size) {
        this._size = _size;
    }
}