/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.sql.Connection;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.Constructor;

/**
 * @author Yasuo Nakanishi
 */
public class QueryConstructor extends Constructor {
    private Value _connectinonArgument = new Value(Connection.class,
            "connection");

    public QueryConstructor(final Type type) {
        super(type);
    }

    public void setupSignature() {
        addArgument(_connectinonArgument);

        getJavaDoc().addLine(getName() + "NX̃RXgN^B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("f[^x[XRlNVIuWFNgƂăNGNX쐬܂B<br>");
        getJavaDoc().addLine("̃NX̗ṕAK close()\bhĂяoKv܂B<br>");
        getJavaDoc().addParameter(_connectinonArgument.getName(), "f[^x[Xڑ");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        final Value connectionField = new Value(Connection.class, "fConnection");
        implementor.assign(connectionField, _connectinonArgument);
    }
}