/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.service;

import java.io.File;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;
import blanco.service.valueobject.BlancoServiceStructure;

/**
 * ۏNX̃\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
class BlancoServiceXml2SourceFileAbstractProcess {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void process(final BlancoServiceStructure argProcessStructure,
            final File argDirectoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argProcessStructure
                .getPackage(), "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgClass = fCgFactory.createClass("Abstract"
                + argProcessStructure.getName() + "Process", "T[rX`ID["
                + argProcessStructure.getName() + "]̒ۏNXB");
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.getImplementInterfaceList().add(
                fCgFactory.createType("java.lang.Runnable"));
        fCgClass.setAbstract(true);
        if (BlancoStringUtil.null2Blank(argProcessStructure.getDescription())
                .length() > 0) {
            fCgClass.getLangDoc().getDescriptionList().add(
                    ": " + argProcessStructure.getDescription() + "<br>");
        }
        fCgClass.getLangDoc().getDescriptionList().add(
                "̃NX́AJavaŏꂽAvP[VAvP[VT[oɏ풓邽߂̎dg݂̈ꕔłB<br>");
        fCgClass.getLangDoc().getDescriptionList().add(
                "̃NXp " + argProcessStructure.getName()
                        + "Process ƂNXA̒ɋ̓IȏLڂĂB");

        expandMethodRun(argProcessStructure);
        expandMethodExecute(argProcessStructure);
        expandMethodStop(argProcessStructure);

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * run \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodRun(
            final BlancoServiceStructure argProcessStructure) {

        final BlancoCgMethod method = fCgFactory.createMethod("run",
                "XbhƂē삷ۂ̃Gg|CgB");
        fCgClass.getMethodList().add(method);

        method.setFinal(true);
        method.getLangDoc().getDescriptionList().add(
                "java.lang.Runnable XbhƂĎsꂽۂɁÃ\bhĂяo܂B");

        final List listLine = method.getLineList();

        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + "Process: begin.\");");
        listLine.add("");
        listLine.add("try {");
        listLine.add("execute();");
        listLine.add("} catch (Exception ex) {");
        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + "Process: exception: \" + ex.toString());");
        listLine.add("ex.printStackTrace();");
        listLine.add("} catch (Error er) {");
        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + "Process: error: \" + er.toString());");
        listLine.add("er.printStackTrace();");
        listLine.add("}");
        listLine.add("");
        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + "Process: end.\");");
    }

    /**
     * execute \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodExecute(
            final BlancoServiceStructure argProcessStructure) {

        final BlancoCgMethod method = fCgFactory.createMethod("execute",
                "ۂ̏eLq郁\bhB");
        fCgClass.getMethodList().add(method);

        method.setAbstract(true);
        method.getLangDoc().getDescriptionList().add(
                "̃\bhāAۂ̏Lqs܂B");
    }

    /**
     * stop \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodStop(
            final BlancoServiceStructure argProcessStructure) {

        final BlancoCgMethod method = fCgFactory.createMethod("stop",
                "~ۂɌĂяo郁\bhB");
        fCgClass.getMethodList().add(method);

        method.getLangDoc().getDescriptionList().add(
                "~Lq܂BʂȒ~Ȃꍇɂ́Ã\bh㏑Kv͂܂B");

        final List listLine = method.getLineList();
        listLine.add("// ɉ͍s܂B");
        listLine.add("System.out.println(\"" + argProcessStructure.getName()
                + "Process: stop.\");");
    }
}
