/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.Scope;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

public class FinalizeDotNet extends MethodExpander {
    private BlancoDbObjectStorageDotNet storage = null;

    private String className = null;

    public FinalizeDotNet(final BlancoDbObjectStorageDotNet storage,
            final String className) {
        super("Finalize");
        this.storage = storage;
        this.className = className;
    }

    protected Scope getScope() {
        return Scope.PROTECTED;
    }

    public void setupSignature() {
        getJavaDoc().addLine("Finalize\bh");
        getJavaDoc().addLine("N[YỸoOm邱ƂړIƂ܂B");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        implementor.addLine("if (fStatement != null) {");
        implementor.addLine("const String message = \"" + className
                + " : Close()\bhɂ郊\[X̊JsĂ܂B\";");
        implementor.addLine("System.Console.WriteLine(message);");

        if (storage.getSetting().isLogging()) {
            implementor.addLine("");
            implementor.addLine("fLog.error(\"" + getName()
                    + ": \" + message);");
        }

        implementor.addLine("}");
    }
}