/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.util.HashMap;
import java.util.Iterator;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.definition.QueryCallerDotNet;
import blanco.db.mapping.BlancoDbMappingUtilDotNet;
import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.db.util.BlancoDbQueryParserUtilDotNet;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class GetCallerOutputParameterMethodDotNet extends MethodExpander {
    private BlancoDbObjectStorageDotNet storage = null;

    private QueryCallerDotNet _caller = null;

    private IgValue fVal = null;

    public GetCallerOutputParameterMethodDotNet(
            final BlancoDbObjectStorageDotNet storage,
            final QueryCallerDotNet caller, IgValue val) {
        super("Get" + BlancoNameAdjuster.toClassName(val.getName()));
        _caller = caller;
        this.storage = storage;
        this.fVal = val;
    }

    public void setupSignature() {
        getJavaDoc().addLine("XgAhvV[W̎sʂ̏o̓p[^擾܂B");
        getJavaDoc().addLine("XgAhvV[W̎sʂƂĖ߂Ƃł̂͒lЂƂłB");

        final Iterator ite = _caller.getOutParameterIterator();
        while (ite.hasNext()) {
            final IgValue val = (IgValue) ite.next();

            if (fVal.getName().equals(val.getName()) == false) {
                // ^[Qbgł͂Ȃ̂ŏXLbv܂B
                continue;
            }

            setReturnType(val.getType());
        }
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            getData().addLine("if (fLog.isDebugEnabled()) {");
            getData().addLine("fLog.debug(\"" + getName() + "\");");
            getData().addLine("}");
            getData().addLine("");
        }

        getJavaDoc().addLine("NGɗ^̓p[^Zbg܂B");

        final BlancoDbQueryParserUtilDotNet query = new BlancoDbQueryParserUtilDotNet(
                _caller.getQuery());

        // ɏp[^̃}bvB
        final HashMap mapProcessedParam = new HashMap();

        final Iterator ite = _caller.getOutParameterIterator();
        while (ite.hasNext()) {
            // TODO: SQLp[^𔭌ȂĂ͂Ȃ܂B
            // AƂ肠^ꂽœoƉ肪Ă܂B
            final IgValue val = (IgValue) ite.next();

            final int[] listCol = query.getSqlParameters(val.getName());
            if (listCol == null) {
                throw new IllegalArgumentException("SQL`ID["
                        + _caller.getName() + "] SQLo̓p[^[" + val.getName()
                        + "]тĂ܂.");
            }

            if (fVal.getName().equals(val.getName()) == false) {
                // ^[Qbgł͂Ȃ̂ŏXLbv܂B
                continue;
            }

            // ɏς̃p[^ƂċL܂B
            mapProcessedParam.put(val.getName(), val);

            if (BlancoDbMappingUtilDotNet.isMapWrapperClassNecessity(val
                    .getType().getName())) {
                getData()
                        .addLine(
                                "// ̃o[WblancoDbDotNetłnulli[Ăꍇ̎擾ʂADO.NETɈˑ܂B");
            }
            getData().addLine(
                    "return (" + val.getType().getFullName()
                            + ") fStatement.Parameters[\"@" + val.getName()
                            + "\"].Value;");
        }
    }
}