/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.util.Iterator;

import blanco.db.definition.QueryCallerDotNet;
import blanco.db.mapping.BlancoDbMappingUtilDotNet;
import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.db.util.BlancoDbQueryParserUtilDotNet;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author tosiki iga
 */
public class PrepareCallMethod2DotNet extends MethodExpander {
    BlancoDbObjectStorageDotNet storage = null;

    private QueryCallerDotNet _caller = null;

    private IgValue queryArgument = new IgValue(new IgType("string"), "query");

    public PrepareCallMethod2DotNet(final BlancoDbObjectStorageDotNet storage,
            final QueryCallerDotNet caller) {
        super("PrepareCall");
        this.storage = storage;
        _caller = caller;

        addUsingType(new IgType("System.Data.SqlDbType"));
    }

    public void setupSignature() {
        // ǉĂ݂B
        addArgument(queryArgument);
        getJavaDoc().addLine("NG̃vRpC{܂B");
        getJavaDoc().addLine("Iɓeω悤SQLsKvꍇɂ̂݁Ã\bh𗘗p܂B");
        getJavaDoc()
                .addLine(
                        "SQL̂̂p[^Ƃė^邱ƂłĎRxASQLCWFNVƌĂ΂ZLeBz[댯_ɒӂŗpĂB");
        getJavaDoc().addLine("Iɂ SqlCommandIuWFNgVK쐬܂B");
        getJavaDoc().addParameter("query", "pNG(SQL)");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName()
                    + ": query = \" + query);");
            implementor.addLine("}");
            implementor.addLine("");
        }

        implementor.addLine("Close();");

        implementor.addLine("fStatement = new SqlCommand();");
        implementor.addLine("fStatement.Connection = fConnection;");
        implementor.addLine("fStatement.Transaction = fTransaction;");
        implementor.addLine("fStatement.CommandText = query;");

        // |Cg: fStatement.CommandType = CommandType.StoredProcedure
        // w肷Ɗ]铮ɂ͂Ȃ܂B

        final BlancoDbQueryParserUtilDotNet query = new BlancoDbQueryParserUtilDotNet(
                _caller.getQuery());

        final Iterator ite = _caller.getOutParameterIterator();
        for (int index = 1; ite.hasNext(); index++) {
            // AƂ肠^ꂽœoƉ肪Ă܂B
            final IgValue val = (IgValue) ite.next();

            implementor.addLine("");
            implementor.addLine("// SQLo̓p[^[" + val.getName() + "]ݒ肵܂B");
            final String stmtLine = "SqlParameter sqlOutParameter"
                    + index
                    + " = new SqlParameter(\"@"
                    + val.getName()
                    + "\", "
                    + BlancoDbMappingUtilDotNet.convertJavaTypeToJdbcType(val
                            .getType().getFullName()) + ");";
            implementor.addLine(stmtLine);
            implementor.addLine("sqlOutParameter" + index
                    + ".Direction = ParameterDirection.Output;");

            if (val.getType().getName().equals("string")) {
                implementor.addLine("// string^͊҂TCY8000Ƃ܂B");
                implementor
                        .addLine("sqlOutParameter" + index + ".Size = 8000;");
            }

            implementor.addLine("fStatement.Parameters.Add(sqlOutParameter"
                    + index + ");");
        }
    }
}