/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.util.Iterator;

import blanco.db.definition.QueryCallerDotNet;
import blanco.db.expander.query.FinalizeDotNet;
import blanco.db.expander.query.GetQueryMethodDotNet;
import blanco.db.expander.query.GetStatementMethodDotNet;
import blanco.db.expander.query.QueryConstructor2DotNet;
import blanco.db.expander.query.QueryConstructorDotNet;
import blanco.db.expander.query.field.ConnectionFieldDotNet;
import blanco.db.expander.query.field.StatementFieldDotNet;
import blanco.db.expander.query.field.TransactionFieldDotNet;
import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.Scope;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.IgStatement;

/**
 * @author Yasuo Nakanishi
 */
public class QueryCallerClassDotNet extends ClassExpander {
    private BlancoDbObjectStorageDotNet storage = null;

    private QueryCallerDotNet _caller = null;

    public QueryCallerClassDotNet(final BlancoDbObjectStorageDotNet storage,
            final IgType type, final QueryCallerDotNet caller) {
        super(type);
        _caller = caller;
        this.storage = storage;

        addImport(new IgType("string"));

        getJavaDoc().addLine(type.getName() + "NX");
        getJavaDoc().addLine("QueryCallerɑNXłB");
        getJavaDoc().addLine("ďo^SQLbsOĊeANZT񋟂܂B");
    }

    protected void expandClassStruct() {
        addField(new ConnectionFieldDotNet());
        // .NET Framework̏ꍇɂ̓gUNVIuWFNgKvłB
        addField(new TransactionFieldDotNet());
        addField(new StatementFieldDotNet());

        if (storage.getSetting().isLogging()) {
            addImport(new IgType("org.apache.commons.logging.LogFactory"));
            final FieldExpander field1 = new FieldExpander(new IgType(
                    "org.apache.commons.logging.Log"), "fLog") {
                protected Scope getScope() {
                    // TODO ꂽ\bhEX^u
                    return Scope.PROTECTED;
                }

                protected boolean isStatic() {
                    return true;
                }
            };
            field1.getJavaDoc().addLine("MÔ߂̃IuWFNg");
            field1.getJavaDoc().addLine("static final̏Ԃňێ܂");
            field1.setDefaultStatement(new IgStatement("LogFactory.getLog("
                    + getName() + ".class)"));
            addField(field1);
        }

        addMethod(new QueryConstructorDotNet(getType()));
        addMethod(new QueryConstructor2DotNet(getType()));

        addMethod(new GetQueryMethodDotNet(_caller.getQuery()));

        addMethod(new PrepareCallMethodDotNet(storage));
        addMethod(new PrepareCallMethod2DotNet(storage, _caller));

        addMethod(new SetCallerInputParameterMethodDotNet(storage, _caller));

        addMethod(new ExecuteMethodDotNet(storage));

        final Iterator ite = _caller.getOutParameterIterator();
        while (ite.hasNext()) {
            final IgValue val = (IgValue) ite.next();
            addMethod(new GetCallerOutputParameterMethodDotNet(storage,
                    _caller, val));
        }

        addMethod(new GetStatementMethodDotNet(storage));

        addMethod(new CloseMethodDotNet(storage));

        addMethod(new FinalizeDotNet(storage, getName()));
    }
}